/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.DoubleConsumer;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRelativeElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;

public class GuiSlider
extends GuiRelativeElement {
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "smooth_slider.png");
    private final DoubleConsumer callback;
    private double value;
    private boolean isDragging;

    public GuiSlider(IGuiWrapper gui, int x, int y, int width, DoubleConsumer callback) {
        super(gui, x, y, width, 12);
        this.callback = callback;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void renderBackgroundOverlay(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderBackgroundOverlay(matrix, mouseX, mouseY);
        GuiUtils.fill(matrix, this.getButtonX() + 2, this.getButtonY() + 3, this.getButtonWidth() - 4, 6, -11184811);
        GuiSlider.minecraft.field_71446_o.func_110577_a(SLIDER);
        int posX = (int)(this.value * (double)(this.getButtonWidth() - 6));
        GuiSlider.func_238463_a_((MatrixStack)matrix, (int)(this.getButtonX() + posX), (int)this.getButtonY(), (float)0.0f, (float)0.0f, (int)7, (int)12, (int)12, (int)12);
    }

    @Override
    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_231000_a__(mouseX, mouseY);
        this.isDragging = false;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        if (this.func_230992_c_(mouseX, mouseY)) {
            this.set(mouseX, mouseY);
            this.isDragging = true;
        }
    }

    @Override
    public void func_230983_a_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        super.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld);
        if (this.isDragging) {
            this.set(mouseX, mouseY);
        }
    }

    private void set(double mouseX, double mouseY) {
        this.value = (mouseX - (double)this.getButtonX() - 2.0) / (double)(this.getButtonWidth() - 6);
        this.value = Math.max(0.0, Math.min(1.0, this.value));
        this.callback.accept(this.value);
    }
}

