/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketGuiSetFrequency;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiQuantumEntangloporter
extends GuiConfigurableTile<TileEntityQuantumEntangloporter, MekanismTileContainer<TileEntityQuantumEntangloporter>> {
    private MekanismButton publicButton;
    private MekanismButton privateButton;
    private MekanismButton setButton;
    private MekanismButton deleteButton;
    private GuiTextScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;

    public GuiQuantumEntangloporter(MekanismTileContainer<TileEntityQuantumEntangloporter> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        InventoryFrequency frequency = ((TileEntityQuantumEntangloporter)this.tile).getFreq();
        if (frequency != null) {
            this.privateMode = frequency.isPrivate();
        }
        this.field_147000_g += 64;
        this.field_238743_q_ = 4;
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.scrollList = new GuiTextScrollList(this, 27, 36, 122, 42);
        this.func_230480_a_(this.scrollList);
        this.func_230480_a_(new GuiUpgradeTab(this, this.tile));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.publicButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 14, 60, 20, MekanismLang.PUBLIC, () -> {
            this.privateMode = false;
            this.updateButtons();
        });
        this.func_230480_a_(this.publicButton);
        this.privateButton = new TranslationButton(this, this.field_147003_i + 89, this.field_147009_r + 14, 60, 20, MekanismLang.PRIVATE, () -> {
            this.privateMode = true;
            this.updateButtons();
        });
        this.func_230480_a_(this.privateButton);
        this.setButton = new TranslationButton(this, this.field_147003_i + 27, this.field_147009_r + 116, 60, 20, MekanismLang.BUTTON_SET, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? (Frequency)((TileEntityQuantumEntangloporter)this.tile).getPrivateCache(FrequencyType.INVENTORY).get(selection) : (Frequency)((TileEntityQuantumEntangloporter)this.tile).getPublicCache(FrequencyType.INVENTORY).get(selection);
                this.setFrequency(freq.getName());
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.setButton);
        this.deleteButton = new TranslationButton(this, this.field_147003_i + 89, this.field_147009_r + 116, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? (Frequency)((TileEntityQuantumEntangloporter)this.tile).getPrivateCache(FrequencyType.INVENTORY).get(selection) : (Frequency)((TileEntityQuantumEntangloporter)this.tile).getPublicCache(FrequencyType.INVENTORY).get(selection);
                Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.REMOVE_TILE, FrequencyType.INVENTORY, freq.getIdentity(), ((TileEntityQuantumEntangloporter)this.tile).func_174877_v()));
                this.scrollList.clearSelection();
            }
            this.updateButtons();
        });
        this.func_230480_a_(this.deleteButton);
        this.frequencyField = new GuiTextField(this, 50, 103, 98, 11);
        this.func_230480_a_(this.frequencyField);
        this.frequencyField.setMaxStringLength(16);
        this.frequencyField.setBackground(BackgroundType.INNER_SCREEN);
        this.frequencyField.setEnterHandler(this::setFrequency);
        this.frequencyField.setInputValidator(InputValidator.or(InputValidator.DIGIT, InputValidator.LETTER, InputValidator.FREQUENCY_CHARS));
        this.frequencyField.addCheckmarkButton(this::setFrequency);
        this.func_230480_a_(new GuiEnergyTab(() -> {
            InventoryFrequency frequency = ((TileEntityQuantumEntangloporter)this.tile).getFreq();
            EnergyDisplay storing = frequency == null ? EnergyDisplay.ZERO : EnergyDisplay.of(frequency.storedEnergy.getEnergy(), frequency.storedEnergy.getMaxEnergy());
            EnergyDisplay rate = EnergyDisplay.of(((TileEntityQuantumEntangloporter)this.tile).getInputRate());
            return Arrays.asList(MekanismLang.STORING.translate(storing), MekanismLang.MATRIX_INPUT_RATE.translate(rate));
        }, (IGuiWrapper)this));
        this.func_230480_a_(new GuiHeatTab(() -> {
            ITextComponent transfer = MekanismUtils.getTemperatureDisplay(((TileEntityQuantumEntangloporter)this.tile).getLastTransferLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((TileEntityQuantumEntangloporter)this.tile).getLastEnvironmentLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Arrays.asList(MekanismLang.TRANSFERRED_RATE.translate(transfer), MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
        this.updateButtons();
    }

    public void setFrequency(String freq) {
        if (!freq.isEmpty()) {
            Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.SET_TILE, FrequencyType.INVENTORY, new Frequency.FrequencyIdentity(freq, !this.privateMode), ((TileEntityQuantumEntangloporter)this.tile).func_174877_v()));
        }
    }

    public ITextComponent getSecurity(Frequency freq) {
        if (freq.isPublic()) {
            return MekanismLang.PUBLIC.translate(new Object[0]);
        }
        return MekanismLang.PRIVATE.translateColored(EnumColor.DARK_RED, new Object[0]);
    }

    private void updateButtons() {
        if (((TileEntityQuantumEntangloporter)this.tile).getOwnerName() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : ((TileEntityQuantumEntangloporter)this.tile).getPrivateCache(FrequencyType.INVENTORY)) {
                text.add(freq.getName());
            }
        } else {
            for (Frequency freq : ((TileEntityQuantumEntangloporter)this.tile).getPublicCache(FrequencyType.INVENTORY)) {
                text.add(freq.getName() + " (" + freq.getClientOwner() + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_230693_o_ = true;
            this.privateButton.field_230693_o_ = false;
        } else {
            this.publicButton.field_230693_o_ = false;
            this.privateButton.field_230693_o_ = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? (Frequency)((TileEntityQuantumEntangloporter)this.tile).getPrivateCache(FrequencyType.INVENTORY).get(this.scrollList.getSelection()) : (Frequency)((TileEntityQuantumEntangloporter)this.tile).getPublicCache(FrequencyType.INVENTORY).get(this.scrollList.getSelection());
            Frequency frequency = ((TileEntityQuantumEntangloporter)this.tile).getFrequency(null);
            this.setButton.field_230693_o_ = frequency == null || !frequency.equals(freq);
            UUID ownerUUID = ((TileEntityQuantumEntangloporter)this.tile).getOwnerUUID();
            this.deleteButton.field_230693_o_ = ownerUUID != null && freq.ownerMatches(ownerUUID);
        } else {
            this.setButton.field_230693_o_ = false;
            this.deleteButton.field_230693_o_ = false;
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateButtons();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.updateButtons();
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFrequency() {
        this.setFrequency(this.frequencyField.getText());
        this.frequencyField.setText("");
        this.updateButtons();
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, OwnerDisplay.of(((TileEntityQuantumEntangloporter)this.tile).getOwnerUUID(), ((TileEntityQuantumEntangloporter)this.tile).getOwnerName()).getTextComponent(), 8, this.field_147000_g - 96 + 4, this.titleTextColor());
        TranslationTextComponent frequencyComponent = MekanismLang.FREQUENCY.translate(new Object[0]);
        this.drawString(matrix, (ITextComponent)frequencyComponent, 32, 81, this.titleTextColor());
        TranslationTextComponent securityComponent = MekanismLang.SECURITY.translate("");
        this.drawString(matrix, (ITextComponent)securityComponent, 32, 91, this.titleTextColor());
        InventoryFrequency frequency = ((TileEntityQuantumEntangloporter)this.tile).getFreq();
        int frequencyOffset = this.getStringWidth((ITextComponent)frequencyComponent) + 1;
        if (frequency == null) {
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + frequencyOffset, 81, this.subheadingTextColor());
            this.drawString(matrix, (ITextComponent)MekanismLang.NONE.translateColored(EnumColor.DARK_RED, new Object[0]), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, this.subheadingTextColor());
        } else {
            this.drawTextScaledBound(matrix, frequency.getName(), 32 + frequencyOffset, 81.0f, this.subheadingTextColor(), this.field_146999_f - 32 - frequencyOffset - 4);
            this.drawString(matrix, this.getSecurity(frequency), 32 + this.getStringWidth((ITextComponent)securityComponent), 91, this.subheadingTextColor());
        }
        this.drawTextScaledBound(matrix, (ITextComponent)MekanismLang.SET.translate(new Object[0]), 27.0f, 104.0f, this.titleTextColor(), 20.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

