/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MovableFilterButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.common.Mekanism;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.HashList;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiFilterHolder<FILTER extends IFilter<?>, TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanismTile<TILE, CONTAINER> {
    private static final int FILTER_COUNT = 4;
    private GuiScrollBar scrollBar;

    public GuiFilterHolder(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 86;
        this.field_238745_s_ = this.field_147000_g - 92;
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiInnerScreen(this, 9, 17, 46, 140));
        this.func_230480_a_(new GuiElementHolder(this, 55, 17, 98, 118));
        this.func_230480_a_(new GuiElementHolder(this, 55, 135, 98, 22));
        this.scrollBar = new GuiScrollBar((IGuiWrapper)this, 153, 17, 140, () -> this.getFilters().size(), () -> 4);
        this.func_230480_a_(this.scrollBar);
        for (int i = 0; i < 4; ++i) {
            this.func_230480_a_(new MovableFilterButton(this, 56, 18 + i * 29, i, this.scrollBar::getCurrentSelection, this::getFilters, index -> {
                if (index > 0) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_UP, (TileEntity)this.tile, index));
                }
            }, index -> {
                if (index < this.getFilters().size() - 1) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_DOWN, (TileEntity)this.tile, index));
                }
            }, this::onClick, filter -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                if (filter != null) {
                    if (filter instanceof IItemStackFilter) {
                        list.add(((IItemStackFilter)filter).getItemStack());
                    } else if (filter instanceof ITagFilter) {
                        list.addAll(this.getTagStacks(((ITagFilter)filter).getTagName()));
                    } else if (filter instanceof IMaterialFilter) {
                        list.addAll(TagCache.getMaterialStacks(((IMaterialFilter)filter).getMaterialItem()));
                    } else if (filter instanceof IModIDFilter) {
                        list.addAll(TagCache.getModIDStacks(((IModIDFilter)filter).getModID(), false));
                    }
                }
                return list;
            }));
        }
    }

    protected HashList<FILTER> getFilters() {
        return ((ITileFilterHolder)((Object)this.tile)).getFilters();
    }

    protected abstract void onClick(IFilter<?> var1, int var2);

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.func_231043_a_(mouseX, mouseY, delta);
    }

    protected abstract List<ItemStack> getTagStacks(String var1);

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.drawForegroundText(matrix, mouseX, mouseY);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
    }
}

