/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.function.LongSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalDissolutionCachedRecipe
extends CachedRecipe<ChemicalDissolutionRecipe> {
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;
    private long gasUsageMultiplier;

    public ChemicalDissolutionCachedRecipe(ChemicalDissolutionRecipe recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, ILongInputHandler<@NonNull GasStack> chemicalInputHandler, LongSupplier gasUsage, BoxedChemicalOutputHandler outputHandler) {
        super(recipe);
        this.itemInputHandler = itemInputHandler;
        this.gasInputHandler = chemicalInputHandler;
        this.gasUsage = gasUsage;
        this.outputHandler = outputHandler;
    }

    @Override
    protected void setupVariableValues() {
        this.gasUsageMultiplier = this.gasUsage.getAsLong();
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return 0;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(((ChemicalDissolutionRecipe)this.recipe).getItemInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        currentMax = this.gasInputHandler.operationsCanSupport((InputIngredient<GasStack>)((ChemicalDissolutionRecipe)this.recipe).getGasInput(), currentMax, this.gasUsageMultiplier);
        return this.outputHandler.operationsRoomFor(((ChemicalDissolutionRecipe)this.recipe).getOutput(recipeItem, recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (!gasStack.isEmpty() && ((ChemicalDissolutionRecipe)this.recipe).test(this.itemInputHandler.getInput(), gasStack)) {
            GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use(recipeGas, (long)operations * this.gasUsageMultiplier);
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(recipeItem, operations);
        this.gasInputHandler.use(recipeGas, operations);
        this.outputHandler.handleOutput(((ChemicalDissolutionRecipe)this.recipe).getOutput(recipeItem, recipeGas), operations);
    }
}

