/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemical;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class BoxedChemicalStack
implements IHasTextComponent {
    public static final BoxedChemicalStack EMPTY = new BoxedChemicalStack(ChemicalType.GAS, GasStack.EMPTY);
    private final ChemicalType chemicalType;
    private final ChemicalStack<?> chemicalStack;

    public static BoxedChemicalStack box(ChemicalStack<?> chemicalStack) {
        return new BoxedChemicalStack(ChemicalType.getTypeFor(chemicalStack), chemicalStack);
    }

    public static BoxedChemicalStack read(@Nullable CompoundNBT nbt) {
        ChemicalType chemicalType = ChemicalType.fromNBT(nbt);
        ChemicalStack stack = null;
        if (chemicalType == ChemicalType.GAS) {
            stack = GasStack.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.INFUSION) {
            stack = InfusionStack.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.PIGMENT) {
            stack = PigmentStack.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.SLURRY) {
            stack = SlurryStack.readFromNBT(nbt);
        }
        return chemicalType == null || stack == null ? EMPTY : new BoxedChemicalStack(chemicalType, stack);
    }

    private BoxedChemicalStack(ChemicalType chemicalType, ChemicalStack<?> chemicalStack) {
        this.chemicalType = chemicalType;
        this.chemicalStack = chemicalStack;
    }

    public BoxedChemical getType() {
        return new BoxedChemical(this.chemicalType, (Chemical<?>)this.chemicalStack.getType());
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.chemicalStack.isEmpty();
    }

    public CompoundNBT write(CompoundNBT nbt) {
        this.chemicalType.write(nbt);
        this.chemicalStack.write(nbt);
        return nbt;
    }

    public ChemicalStack<?> getChemicalStack() {
        return this.chemicalStack;
    }

    @Override
    public ITextComponent getTextComponent() {
        return this.chemicalStack.getTextComponent();
    }
}

