/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas.attribute;

import java.util.List;
import java.util.function.IntSupplier;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IGasProvider;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import net.minecraft.util.text.ITextComponent;

public class GasAttributes {
    private GasAttributes() {
    }

    public static class Fuel
    extends ChemicalAttribute {
        private final IntSupplier burnTicks;
        private final FloatingLongSupplier energyDensity;

        public Fuel(IntSupplier burnTicks, FloatingLongSupplier energyDensity) {
            this.burnTicks = burnTicks;
            this.energyDensity = energyDensity;
        }

        public int getBurnTicks() {
            return this.burnTicks.getAsInt();
        }

        public FloatingLong getEnergyPerTick() {
            return this.getBurnTicks() == 0 ? this.energyDensity.get() : this.energyDensity.get().divide(this.getBurnTicks());
        }
    }

    public static class HeatedCoolant
    extends Coolant {
        private final IGasProvider cooledGas;

        public HeatedCoolant(IGasProvider cooledGas, double thermalEnthalpy, double conductivity) {
            super(thermalEnthalpy, conductivity);
            this.cooledGas = cooledGas;
        }

        public Gas getCooledGas() {
            return (Gas)this.cooledGas.getChemical();
        }
    }

    public static class CooledCoolant
    extends Coolant {
        private final IGasProvider heatedGas;

        public CooledCoolant(IGasProvider heatedGas, double thermalEnthalpy, double conductivity) {
            super(thermalEnthalpy, conductivity);
            this.heatedGas = heatedGas;
        }

        public IGasProvider getHeatedGas() {
            return (IGasProvider)this.heatedGas.getChemical();
        }
    }

    public static abstract class Coolant
    extends ChemicalAttribute {
        private final double thermalEnthalpy;
        private final double conductivity;

        public Coolant(double thermalEnthalpy, double conductivity) {
            this.thermalEnthalpy = thermalEnthalpy;
            this.conductivity = conductivity;
        }

        public double getThermalEnthalpy() {
            return this.thermalEnthalpy;
        }

        public double getConductivity() {
            return this.conductivity;
        }

        @Override
        public List<ITextComponent> addTooltipText(List<ITextComponent> list) {
            super.addTooltipText(list);
            list.add((ITextComponent)APILang.CHEMICAL_ATTRIBUTE_COOLANT_EFFICIENCY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, Math.round(this.conductivity * 100.0) + "%"));
            list.add((ITextComponent)APILang.CHEMICAL_ATTRIBUTE_COOLANT_ENTHALPY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.thermalEnthalpy));
            return list;
        }
    }

    public static class Radiation
    extends ChemicalAttribute {
        private final double radioactivity;

        public Radiation(double radioactivity) {
            this.radioactivity = radioactivity;
        }

        public double getRadioactivity() {
            return this.radioactivity;
        }

        @Override
        public boolean needsValidation() {
            return true;
        }

        @Override
        public List<ITextComponent> addTooltipText(List<ITextComponent> list) {
            super.addTooltipText(list);
            list.add((ITextComponent)APILang.CHEMICAL_ATTRIBUTE_RADIATION.translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.radioactivity));
            return list;
        }
    }
}

