/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.math.MathUtils;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum Upgrade implements IHasTranslationKey
{
    SPEED("speed", APILang.UPGRADE_SPEED, APILang.UPGRADE_SPEED_DESCRIPTION, 8, EnumColor.RED),
    ENERGY("energy", APILang.UPGRADE_ENERGY, APILang.UPGRADE_ENERGY_DESCRIPTION, 8, EnumColor.BRIGHT_GREEN),
    FILTER("filter", APILang.UPGRADE_FILTER, APILang.UPGRADE_FILTER_DESCRIPTION, 1, EnumColor.DARK_AQUA),
    GAS("gas", APILang.UPGRADE_GAS, APILang.UPGRADE_GAS_DESCRIPTION, 8, EnumColor.YELLOW),
    MUFFLING("muffling", APILang.UPGRADE_MUFFLING, APILang.UPGRADE_MUFFLING_DESCRIPTION, 4, EnumColor.DARK_GRAY),
    ANCHOR("anchor", APILang.UPGRADE_ANCHOR, APILang.UPGRADE_ANCHOR_DESCRIPTION, 1, EnumColor.DARK_GREEN);

    private static final Upgrade[] UPGRADES;
    private final String name;
    private final APILang langKey;
    private final APILang descLangKey;
    private final int maxStack;
    private final EnumColor color;

    private Upgrade(String name, APILang langKey, APILang descLangKey, int maxStack, EnumColor color) {
        this.name = name;
        this.langKey = langKey;
        this.descLangKey = descLangKey;
        this.maxStack = maxStack;
        this.color = color;
    }

    public static Map<Upgrade, Integer> buildMap(@Nullable CompoundNBT nbtTags) {
        EnumMap<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
        if (nbtTags != null && nbtTags.func_150297_b("upgrades", 9)) {
            ListNBT list = nbtTags.func_150295_c("upgrades", 10);
            for (int tagCount = 0; tagCount < list.size(); ++tagCount) {
                CompoundNBT compound = list.func_150305_b(tagCount);
                Upgrade upgrade = Upgrade.byIndexStatic(compound.func_74762_e("type"));
                upgrades.put(upgrade, Math.min(upgrade.maxStack, compound.func_74762_e("amount")));
            }
        }
        return upgrades;
    }

    public static void saveMap(Map<Upgrade, Integer> upgrades, CompoundNBT nbtTags) {
        ListNBT list = new ListNBT();
        for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
            list.add((Object)Upgrade.getTagFor(entry.getKey(), entry.getValue()));
        }
        nbtTags.func_218657_a("upgrades", (INBT)list);
    }

    public static CompoundNBT getTagFor(Upgrade upgrade, int amount) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("type", upgrade.ordinal());
        compound.func_74768_a("amount", amount);
        return compound;
    }

    public String getRawName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        return this.langKey.getTranslationKey();
    }

    public ITextComponent getDescription() {
        return new TranslationTextComponent(this.descLangKey.getTranslationKey());
    }

    public int getMax() {
        return this.maxStack;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public boolean canMultiply() {
        return this.getMax() > 1;
    }

    public static Upgrade byIndexStatic(int index) {
        return MathUtils.getByIndexMod(UPGRADES, index);
    }

    static {
        UPGRADES = Upgrade.values();
    }

    public static interface IUpgradeInfoHandler {
        public List<ITextComponent> getInfo(Upgrade var1);
    }
}

