/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.Objects;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismBlocks;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.tier.BaseTier;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityBasicMachine;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityUpgradeableMachine<INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>>
extends TileEntityBasicMachine<INPUT, OUTPUT, RECIPE>
implements ITierUpgradeable {
    public TileEntityUpgradeableMachine(String soundPath, BlockStateMachine.MachineType type, int upgradeSlot, int baseTicksRequired, ResourceLocation location) {
        super(soundPath, type, upgradeSlot, baseTicksRequired, location);
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        if (upgradeTier != BaseTier.BASIC) {
            return false;
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5), 3);
        TileEntityFactory factory = Objects.requireNonNull((TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v()));
        IFactory.RecipeType type = IFactory.RecipeType.getFromMachine(this.func_145838_q(), this.func_145832_p());
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.progress[0] = this.operatingTicks;
        factory.isActive = this.isActive;
        factory.setControlType(this.getControlType());
        factory.prevEnergy = this.prevEnergy;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.upgradeComponent.setUpgradeSlot(0);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.setRecipeType(type);
        factory.upgradeComponent.setSupported(Upgrade.GAS, type.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        for (TransmissionType transmission : this.configComponent.getTransmissions()) {
            factory.configComponent.setConfig(transmission, this.configComponent.getConfig(transmission).asByteArray());
            factory.configComponent.setEjecting(transmission, this.configComponent.isEjecting(transmission));
        }
        this.upgradeInventory(factory);
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        return true;
    }

    protected abstract void upgradeInventory(TileEntityFactory var1);
}

