/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiEmbeddedGaugeTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiThermoelectricBoiler
extends GuiEmbeddedGaugeTile<TileEntityBoilerCasing> {
    public GuiThermoelectricBoiler(InventoryPlayer inventory, TileEntityBoilerCasing tile) {
        super(tile, new ContainerFilter(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tileEntity, GuiBoilerTab.BoilerTab.STAT, resource));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.boilRate") + ": " + ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastBoilRate() + " mB/t";
            }

            @Override
            public double getLevel() {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure == null ? 0.0 : (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastBoilRate() / (double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastMaxBoil;
            }
        }, resource, 24, 13));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.maxBoil") + ": " + ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastMaxBoil() + " mB/t";
            }

            @Override
            public double getLevel() {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure == null ? 0.0 : (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastMaxBoil() * SynchronizedBoilerData.getHeatEnthalpy() / ((double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).superheatingElements * MekanismConfig.current().general.superheatingHeatTransfer.val());
            }
        }, resource, 144, 13));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityBoilerCasing)this.tileEntity).getLastEnvironmentLoss() * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityBoilerCasing)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityBoilerCasing)this.tileEntity).func_70005_c_()) / 2, 5, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((TileEntityBoilerCasing)this.tileEntity).getTemperature(), UnitDisplayUtils.TemperatureUnit.AMBIENT), 43, 30, 52480, 90);
        this.renderScaledText(LangUtils.localize("gui.boilRate") + ": " + ((TileEntityBoilerCasing)this.tileEntity).getLastBoilRate() + " mB/t", 43, 39, 52480, 90);
        this.renderScaledText(LangUtils.localize("gui.maxBoil") + ": " + ((TileEntityBoilerCasing)this.tileEntity).getLastMaxBoil() + " mB/t", 43, 48, 52480, 90);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72) {
            FluidStack waterStored = ((TileEntityBoilerCasing)this.tileEntity).structure != null ? ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).waterStored : null;
            this.displayTooltip(waterStored != null ? LangUtils.localizeFluidStack(waterStored) + ": " + waterStored.amount + "mB" : LangUtils.localize("gui.empty"), xAxis, yAxis);
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72) {
            FluidStack steamStored = ((TileEntityBoilerCasing)this.tileEntity).structure != null ? ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored : null;
            this.displayTooltip(steamStored != null ? LangUtils.localizeFluidStack(steamStored) + ": " + steamStored.amount + "mB" : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        if (((TileEntityBoilerCasing)this.tileEntity).structure != null) {
            if (((TileEntityBoilerCasing)this.tileEntity).getScaledWaterLevel(58) > 0) {
                this.displayGauge(7, 14, ((TileEntityBoilerCasing)this.tileEntity).getScaledWaterLevel(58), ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).waterStored);
            }
            if (((TileEntityBoilerCasing)this.tileEntity).getScaledSteamLevel(58) > 0) {
                this.displayGauge(153, 14, ((TileEntityBoilerCasing)this.tileEntity).getScaledSteamLevel(58), ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored);
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png");
    }

    @Override
    protected ResourceLocation getGaugeResource() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiIndustrialTurbine.png");
    }
}

