/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.TileEntityFluidTank;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFluidTank
extends TileEntitySpecialRenderer<TileEntityFluidTank> {
    public static final RenderFluidTank INSTANCE = new RenderFluidTank();
    private static FluidRenderMap<MekanismRenderer.DisplayInteger[]> cachedCenterFluids = new FluidRenderMap();
    private static FluidRenderMap<MekanismRenderer.DisplayInteger[]> cachedValveFluids = new FluidRenderMap();
    private static int stages = 1400;

    public static void resetDisplayInts() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    public void render(TileEntityFluidTank tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        FluidStack fluid = tileEntity.fluidTank.getFluid();
        this.render(tileEntity.tier, fluid, tileEntity.prevScale, tileEntity.isActive, tileEntity.valve > 0 ? tileEntity.valveFluid : null, x, y, z);
    }

    public void render(FluidTankTier tier, FluidStack fluid, float fluidScale, boolean active, FluidStack valveFluid, double x, double y, double z) {
        MekanismRenderer.GlowInfo glowInfo;
        boolean glChanged = false;
        if (fluid != null && fluidScale > 0.0f) {
            GlStateManager.func_179094_E();
            glChanged = this.enableGL();
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            glowInfo = MekanismRenderer.enableGlow(fluid);
            MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(fluid);
            if (tier == FluidTankTier.CREATIVE) {
                fluidScale = 1.0f;
            }
            MekanismRenderer.color(fluid, fluidScale);
            if (fluid.getFluid().isGaseous(fluid)) {
                displayList[stages - 1].render();
            } else {
                displayList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            }
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179121_F();
        }
        if (valveFluid != null && !valveFluid.getFluid().isGaseous(valveFluid)) {
            GlStateManager.func_179094_E();
            glChanged = this.enableGL();
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            glowInfo = MekanismRenderer.enableGlow(valveFluid);
            MekanismRenderer.color(valveFluid);
            MekanismRenderer.DisplayInteger[] valveList = this.getValveRender(valveFluid);
            valveList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179121_F();
        }
        if (glChanged) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
        }
    }

    private boolean enableGL() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179140_f();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        return true;
    }

    private MekanismRenderer.DisplayInteger[] getValveRender(FluidStack fluid) {
        if (cachedValveFluids.containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedValveFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        MekanismRenderer.prepFlowing(toReturn, fluid);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedValveFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                toReturn.minX = 0.3225;
                toReturn.minY = 0.0625 + (double)((float)i / (float)stages) * 0.875;
                toReturn.minZ = 0.3225;
                toReturn.maxX = 0.6775;
                toReturn.maxY = 0.9275;
                toReturn.maxZ = 0.6775;
                MekanismRenderer.renderObject(toReturn);
            }
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(FluidStack fluid) {
        if (cachedCenterFluids.containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedCenterFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                toReturn.minX = 0.135;
                toReturn.minY = 0.0725;
                toReturn.minZ = 0.135;
                toReturn.maxX = 0.865;
                toReturn.maxY = 0.0625 + (double)((float)i / (float)stages) * 0.875 - 0.01;
                toReturn.maxZ = 0.865;
                MekanismRenderer.renderObject(toReturn);
            }
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }
}

