/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public abstract class MOImageGen<T extends ImageGenWorker> {
    public static final HashMap<Block, Integer> worldGenerationBlockColors = new HashMap();
    protected final int layerWidth;
    protected final int layerHeight;
    protected final Random localRandom = new Random();
    private final HashMap<Integer, BlockMapping> blockMap = new HashMap();
    protected ResourceLocation texture;
    protected int placeNotify;
    private List<int[][]> layers;
    private int textureWidth;
    private int textureHeight;
    private int layerCount;

    public MOImageGen(ResourceLocation texture, int layerWidth, int layerHeight) {
        this.layerWidth = layerWidth;
        this.layerHeight = layerHeight;
        this.setTexture(texture);
    }

    public static void generateFromImage(World world, BlockPos start, int layerWidth, int layerHeight, List<int[][]> layers, Map<Integer, IBlockState> blockMap) {
        for (int layer = 0; layer < layers.size(); ++layer) {
            for (int x = 0; x < layerWidth; ++x) {
                for (int z = 0; z < layerHeight; ++z) {
                    int color = layers.get(layer)[x][z];
                    Color c = new Color(color, true);
                    IBlockState block = blockMap.get(color & 0xFFFFFF);
                    if (block == null) continue;
                    world.func_180501_a(start.func_177982_a(x, layer, z), block, 2);
                }
            }
        }
    }

    public static List<int[][]> loadTexture(File textureLocation, int layerWidth, int layerHeight) {
        try {
            BufferedImage image = ImageIO.read(textureLocation);
            int textureWidth = image.getWidth();
            int layerCount = image.getWidth() / layerWidth * (image.getHeight() / layerHeight);
            ArrayList<int[][]> layers = new ArrayList<int[][]>();
            for (int i = 0; i < layerCount; ++i) {
                layers.add(new int[layerWidth][layerHeight]);
            }
            MOImageGen.convertTo2DWithoutUsingGetRGB(image, layerWidth, layerHeight, textureWidth, layers);
            return layers;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void convertTo2DWithoutUsingGetRGB(BufferedImage image, int layerWidth, int layerHeight, int textureWidth, List<int[][]> layers) {
        boolean hasAlphaChannel;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        boolean bl = hasAlphaChannel = image.getAlphaRaster() != null;
        if (hasAlphaChannel) {
            int pixelLength = 4;
            int row = 0;
            int col = 0;
            for (int pixel = 0; pixel < pixels.length; pixel += 4) {
                int argb = 0;
                argb += (pixels[pixel] & 0xFF) << 24;
                argb += pixels[pixel + 1] & 0xFF;
                argb += (pixels[pixel + 2] & 0xFF) << 8;
                int layerIndex = Math.floorDiv(col, layerWidth) + textureWidth / layerWidth * Math.floorDiv(row, layerHeight);
                layers.get((int)layerIndex)[col % layerWidth][row % layerHeight] = argb += (pixels[pixel + 3] & 0xFF) << 16;
                if (++col != textureWidth) continue;
                col = 0;
                ++row;
            }
        } else {
            int pixelLength = 3;
            int row = 0;
            int col = 0;
            for (int pixel = 0; pixel < pixels.length; pixel += 3) {
                int argb = 0;
                argb -= 0x1000000;
                argb += pixels[pixel] & 0xFF;
                argb += (pixels[pixel + 1] & 0xFF) << 8;
                int layerIndex = Math.floorDiv(col, layerWidth) + textureWidth / layerWidth * Math.floorDiv(row, layerHeight);
                layers.get((int)layerIndex)[col % layerWidth][row % layerHeight] = argb += (pixels[pixel + 2] & 0xFF) << 16;
                if (++col != textureWidth) continue;
                col = 0;
                ++row;
            }
        }
    }

    private static void transpose(int[][] m) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = i; j < m[0].length; ++j) {
                int x = m[i][j];
                m[i][j] = m[j][i];
                m[j][i] = x;
            }
        }
    }

    public static void swapRows(int[][] m) {
        int i = 0;
        for (int k = m.length - 1; i < k; ++i, --k) {
            int[] x = m[i];
            m[i] = m[k];
            m[k] = x;
        }
    }

    public static void rotateByNinetyToLeft(int[][] m) {
        MOImageGen.transpose(m);
        MOImageGen.swapRows(m);
    }

    public static void rotateByNinetyToRight(int[][] m) {
        MOImageGen.swapRows(m);
        MOImageGen.transpose(m);
    }

    public void placeBlock(World world, int color, BlockPos pos, int layer, Random random, int placeNotify, T worker) {
        IBlockState block = this.getBlockFromColor(color, random);
        if (block != null) {
            world.func_180501_a(pos, block, placeNotify);
            this.onBlockPlace(world, block, pos, random, color, worker);
        }
    }

    public abstract void onBlockPlace(World var1, IBlockState var2, BlockPos var3, Random var4, int var5, T var6);

    public IBlockState getBlockFromColor(int color, Random random) {
        BlockMapping blockMapping = this.blockMap.get(color & 0xFFFFFF);
        if (blockMapping != null) {
            return blockMapping.getBlock(random).func_176203_a(this.getMetaFromColor(color, random));
        }
        return null;
    }

    public int getMetaFromColor(int color, Random random) {
        return 0;
    }

    public void generateFromImage(World world, Random random, BlockPos start, int layer, int placeNotify, T worker) {
        if (this.layers != null && this.layers.size() > 0) {
            for (BlockMapping blockMapping : this.blockMap.values()) {
                blockMapping.reset(this.localRandom);
            }
            this.generateFromImage(world, random, new BlockPos(start.func_177958_n(), Math.min(start.func_177956_o(), world.func_72800_K() - this.layerCount), start.func_177952_p()), this.layers, layer, placeNotify, worker);
        }
    }

    public void generateFromImage(World world, Random random, BlockPos start, List<int[][]> layers, int layer, int placeNotify, T worker) {
        for (int x = 0; x < this.layerWidth; ++x) {
            for (int z = 0; z < this.layerHeight; ++z) {
                this.placeBlock(world, layers.get(layer)[x][z], start.func_177982_a(x, layer, z), layer, random, placeNotify, worker);
            }
        }
    }

    public boolean isOnSolidGround(World world, BlockPos pos, int leaway) {
        return this.isPointOnSolidGround(world, pos, leaway) && this.isPointOnSolidGround(world, pos.func_177982_a(this.layerWidth, 0, 0), leaway) && this.isPointOnSolidGround(world, pos.func_177982_a(this.layerWidth, 0, this.layerHeight), leaway) && this.isPointOnSolidGround(world, pos.func_177982_a(0, 0, this.layerHeight), leaway);
    }

    public boolean isPointOnSolidGround(World world, BlockPos pos, int leaway) {
        for (int i = 0; i < leaway; ++i) {
            if (!this.isBlockSolid(world, pos.func_177982_a(0, -i, 0))) continue;
            return true;
        }
        return false;
    }

    public boolean canFit(World world, BlockPos pos) {
        return !this.isBlockSolid(world, pos.func_177982_a(0, this.layerCount, 0)) && !this.isBlockSolid(world, pos.func_177982_a(this.layerCount, this.layerCount, 0)) && !this.isBlockSolid(world, pos.func_177982_a(this.layerCount, this.layerCount, this.layerCount)) && !this.isBlockSolid(world, pos.func_177982_a(0, this.layerCount, this.layerCount));
    }

    public boolean isBlockSolid(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        if (block.func_177230_c() == Blocks.field_150364_r || block.func_177230_c() == Blocks.field_150363_s && block.func_177230_c() == Blocks.field_150361_u || block.func_177230_c() == Blocks.field_150362_t) {
            return false;
        }
        return block.func_177230_c().func_149730_j(block);
    }

    private boolean inAirFloatRange(World world, BlockPos pos, int maxAirRange) {
        for (int i = 0; i < maxAirRange; ++i) {
            if (!this.isBlockSolid(world, pos.func_177982_a(0, -i, 0)) || this.isBlockSolid(world, pos.func_177982_a(0, -i + 1, 0))) continue;
            return true;
        }
        return false;
    }

    protected boolean colorsMatch(int color0, int color1) {
        return (color0 & 0xFFFFFF) == (color1 & 0xFFFFFF);
    }

    public void manageTextureLoading() {
        if (this.layers == null || this.layers.isEmpty()) {
            this.loadTexture(this.getTexture());
        }
    }

    private void loadTexture(ResourceLocation textureLocation) throws RuntimeException {
        try {
            String path = "/assets/" + textureLocation.func_110624_b() + "/" + textureLocation.func_110623_a();
            InputStream imageStream = this.getClass().getResourceAsStream(path);
            BufferedImage image = ImageIO.read(imageStream);
            this.textureWidth = image.getWidth();
            this.textureHeight = image.getHeight();
            this.layerCount = image.getWidth() / this.layerWidth * (image.getHeight() / this.layerHeight);
            for (int i = 0; i < this.layerCount; ++i) {
                this.layers.add(new int[this.layerWidth][this.layerHeight]);
            }
            MOImageGen.convertTo2DWithoutUsingGetRGB(image, this.layerWidth, this.layerHeight, this.textureWidth, this.layers);
        }
        catch (IOException e) {
            MOLog.error(e.getMessage(), e, new Object[0]);
        }
    }

    public void rotateByNinetyToLeft() {
        this.layers.forEach(MOImageGen::rotateByNinetyToLeft);
    }

    public int getRedFromColor(int color) {
        return color >> 16 & 0xFF;
    }

    public int getGreenFromColor(int color) {
        return color >> 8 & 0xFF;
    }

    public int getBlueFromColor(int color) {
        return color & 0xFF;
    }

    public int getAlphaFromColor(int color) {
        return color >> 24 & 0xFF;
    }

    public int getColorAt(int x, int y, int layer) {
        if (x < this.textureWidth && y < this.textureHeight) {
            return this.layers.get(layer)[this.textureHeight][this.textureWidth];
        }
        return 0;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation textureLocation) {
        this.texture = textureLocation;
        if (this.layers == null) {
            this.layers = new ArrayList<int[][]>();
        } else {
            this.layers.clear();
        }
    }

    public void addMapping(int color, Block ... blocks) {
        this.addMapping(color, new BlockMapping(blocks));
    }

    public void addMapping(int color, boolean noise, Block ... blocks) {
        this.addMapping(color, new BlockMapping(noise, blocks));
    }

    public void addMapping(int color, BlockMapping blockMapping) {
        this.blockMap.put(color, blockMapping);
    }

    public BlockMapping getMapping(int color) {
        return this.blockMap.get(color);
    }

    public abstract void onGenerationWorkerCreated(T var1);

    public abstract T getNewWorkerInstance();

    public T createWorker(Random random, BlockPos pos, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        T worker = this.getNewWorkerInstance();
        ((ImageGenWorker)worker).init(random, pos, world, chunkGenerator, chunkProvider);
        this.onGenerationWorkerCreated(worker);
        return worker;
    }

    public static abstract class ImageGenWorker {
        protected int currentLayer;
        protected Random random;
        BlockPos pos;
        World world;
        IChunkGenerator chunkGenerator;
        IChunkProvider chunkProvider;
        int placeNotify;

        public void init(Random random, BlockPos pos, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            this.pos = pos;
            this.random = random;
            this.world = world;
            this.chunkGenerator = chunkGenerator;
            this.chunkProvider = chunkProvider;
        }

        public abstract boolean generate();

        public World getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public IChunkGenerator getChunkGenerator() {
            return this.chunkGenerator;
        }

        public IChunkProvider getChunkProvider() {
            return this.chunkProvider;
        }

        public int getPlaceNotify() {
            return this.placeNotify;
        }

        public void setPlaceNotify(int placeNotify) {
            this.placeNotify = placeNotify;
        }
    }

    public static class BlockMapping {
        private final Block[] blocks;
        private boolean noise;
        private int lastSelected;

        public BlockMapping(boolean noise, Block ... blocks) {
            this(blocks);
            this.noise = noise;
        }

        public BlockMapping(Block ... blocks) {
            this.blocks = blocks;
        }

        public void reset(Random random) {
            if (!this.noise) {
                this.lastSelected = random.nextInt(this.blocks.length);
            }
        }

        public Block getBlock(Random random) {
            if (this.noise) {
                return this.blocks[random.nextInt(this.blocks.length)];
            }
            return this.blocks[this.lastSelected];
        }

        public Block[] getBlocks() {
            return this.blocks;
        }

        public boolean isNoise() {
            return this.noise;
        }
    }
}

