/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.gen.ISpaceBodyGen;

public class WeightedRandomSpaceGen<T extends SpaceBody> {
    final Random random;
    final List<ISpaceBodyGen<T>> collection = new ArrayList<ISpaceBodyGen<T>>();

    public WeightedRandomSpaceGen(Random random) {
        this.random = random;
    }

    public ISpaceBodyGen<T> getRandomGen(T spaceBody) {
        return this.getRandomGen(this.collection, spaceBody, this.random);
    }

    public ISpaceBodyGen<T> getRandomGen(T spaceBody, Random random) {
        return this.getRandomGen(this.collection, spaceBody, random);
    }

    public ISpaceBodyGen<T> getRandomGen(Collection<ISpaceBodyGen<T>> collection, T spaceBody, Random rangomGen) {
        double totalWeight = 0.0;
        for (ISpaceBodyGen<T> i : collection) {
            totalWeight += i.getWeight(spaceBody);
        }
        ISpaceBodyGen<T> gen = null;
        double random = rangomGen.nextDouble() * totalWeight;
        for (ISpaceBodyGen<T> i : collection) {
            if (!((random -= i.getWeight(spaceBody)) <= 0.0)) continue;
            gen = i;
            break;
        }
        return gen;
    }

    public ISpaceBodyGen<T> getGenAt(int index) {
        return this.collection.get(index);
    }

    public void addGen(ISpaceBodyGen<T> gen) {
        this.collection.add(gen);
    }

    public <K extends ISpaceBodyGen<T>> void addGens(Collection<K> gens) {
        this.collection.addAll(gens);
    }

    public List<ISpaceBodyGen<T>> getGens() {
        return this.collection;
    }
}

