/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.tasks;

import java.text.DecimalFormat;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.util.MatterHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MatterNetworkTaskStorePattern
extends MatterNetworkTask {
    ItemStack itemStack;
    int progress;

    public MatterNetworkTaskStorePattern() {
    }

    public MatterNetworkTaskStorePattern(ItemStack itemStack, int progress) {
        this.itemStack = itemStack;
        this.progress = progress;
    }

    @Override
    protected void init() {
        this.setUnlocalizedName("store_pattern");
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound != null) {
            this.itemStack = new ItemStack(compound.func_74775_l("Item"));
            this.progress = compound.func_74762_e("scan_progress");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (compound != null) {
            NBTTagCompound itemComp = new NBTTagCompound();
            if (this.itemStack != null) {
                this.itemStack.func_77955_b(itemComp);
            }
            compound.func_74782_a("Item", (NBTBase)itemComp);
            compound.func_74768_a("scan_progress", this.progress);
        }
    }

    @Override
    public String getName() {
        return this.itemStack.func_82833_r() + " +" + DecimalFormat.getPercentInstance().format((float)this.progress / 100.0f);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public boolean isValid(World world) {
        if (!super.isValid(world)) {
            return false;
        }
        return MatterHelper.getMatterAmountFromItem(this.itemStack) > 0;
    }
}

