/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.includes;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.api.EmptyEnergyStorage;
import matteroverdrive.items.includes.EnergyContainer;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class MOItemEnergyContainer
extends MOBaseItem {
    public MOItemEnergyContainer(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public static IEnergyStorage getStorage(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        }
        return EmptyEnergyStorage.INSTANCE;
    }

    public int getMaxDamage(ItemStack stack) {
        return MOItemEnergyContainer.getStorage(stack).getMaxEnergyStored();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        IEnergyStorage storage = MOItemEnergyContainer.getStorage(stack);
        return (double)(storage.getMaxEnergyStored() - storage.getEnergyStored()) / (double)storage.getMaxEnergyStored();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 15866137;
    }

    @Override
    public void addDetails(ItemStack stack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        IEnergyStorage storage = MOItemEnergyContainer.getStorage(stack);
        infos.add(TextFormatting.YELLOW + MOEnergyHelper.formatEnergy(storage.getEnergyStored(), (long)storage.getMaxEnergyStored()));
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public ICapabilityProvider createProvider(ItemStack stack) {
        return new EnergyProvider(this.getCapacity(), this.getInput(), this.getOutput()).setStack(stack);
    }

    protected abstract int getCapacity();

    protected abstract int getInput();

    protected abstract int getOutput();

    protected boolean addPoweredItem() {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            if (this.addPoweredItem()) {
                ItemStack powered = new ItemStack((Item)this);
                IEnergyStorage storage = MOItemEnergyContainer.getStorage(powered);
                if (storage instanceof EnergyContainer) {
                    ((EnergyContainer)storage).setFull();
                }
                items.add((Object)powered);
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.createProvider(stack);
    }

    public static class EnergyProvider
    implements ICapabilityProvider {
        private EnergyContainer container;

        public EnergyProvider(int capacity, int input, int output) {
            this.container = new EnergyContainer(capacity, input, output);
        }

        public EnergyProvider(int capacity, int through) {
            this(capacity, through, through);
        }

        public EnergyProvider setStack(ItemStack stack) {
            this.container.setItemStack(stack);
            return this;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.container);
            }
            return null;
        }
    }
}

