/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.includes;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyContainer
extends EnergyStorage
implements INBTSerializable<NBTTagCompound> {
    private ItemStack stack;

    public EnergyContainer(int capacity) {
        super(capacity);
    }

    public EnergyContainer(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public EnergyContainer(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public EnergyContainer(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public void setFull() {
        this.setEnergy(this.capacity);
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.stack;
    }

    public EnergyContainer setItemStack(ItemStack stack) {
        boolean hasTags = stack.func_77942_o();
        if (!hasTags || !stack.func_77978_p().func_74764_b("energy")) {
            if (!hasTags) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_74782_a("energy", (NBTBase)this.serializeNBT());
        } else {
            this.deserializeNBT(stack.func_77978_p().func_74775_l("energy"));
        }
        this.stack = stack;
        return this;
    }

    private NBTTagCompound getStackEnergyTag() {
        return this.stack.func_77978_p().func_74775_l("energy");
    }

    public int getEnergyStored() {
        if (this.stack != null) {
            return this.getStackEnergyTag().func_74762_e("energy");
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        if (this.stack != null) {
            return this.getStackEnergyTag().func_74762_e("capacity");
        }
        return this.capacity;
    }

    public int getMaxExtract() {
        if (this.stack != null) {
            return this.getStackEnergyTag().func_74762_e("maxExtract");
        }
        return this.maxExtract;
    }

    public int getMaxReceive() {
        if (this.stack != null) {
            return this.getStackEnergyTag().func_74762_e("maxReceive");
        }
        return this.maxReceive;
    }

    public void setEnergy(int energy) {
        if (this.stack != null) {
            this.getStackEnergyTag().func_74768_a("energy", energy);
            if (this.getEnergyStored() > this.getMaxEnergyStored()) {
                this.setFull();
            }
            return;
        }
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.setFull();
        }
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxReceive(), amount));
        if (!simulate) {
            if (this.stack != null && energyReceived != 0) {
                this.getStackEnergyTag().func_74768_a("energy", this.getEnergyStored() + energyReceived);
            } else {
                this.energy += energyReceived;
            }
        }
        return energyReceived;
    }

    public int extractEnergy(int amount, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxExtract(), amount));
        if (!simulate) {
            if (this.stack != null && energyExtracted != 0) {
                this.getStackEnergyTag().func_74768_a("energy", this.getEnergyStored() - energyExtracted);
            } else {
                this.energy -= energyExtracted;
            }
        }
        return energyExtracted;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("capacity", this.capacity);
        tag.func_74768_a("maxReceive", this.maxReceive);
        tag.func_74768_a("maxExtract", this.maxExtract);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.energy = tag.func_74762_e("energy");
        this.capacity = tag.func_74762_e("capacity");
        this.maxReceive = tag.func_74762_e("maxReceive");
        this.maxExtract = tag.func_74762_e("maxExtract");
    }

    public void setMaxEnergy(int max) {
        if (this.stack != null) {
            this.getStackEnergyTag().func_74768_a("capacity", max);
            return;
        }
        this.capacity = max;
    }
}

