/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.client.sound.MachineSound;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MatterScanner
extends MOBaseItem
implements IBlockScanner {
    public static final String SELECTED_TAG_NAME = "lastSelected";
    public static final String PAGE_TAG_NAME = "page";
    public static final String PANEL_OPEN_TAG_NAME = "panelOpen";
    public static final int PROGRESS_PER_ITEM = 10;
    public static final int SCAN_TIME = 60;
    @SideOnly(value=Side.CLIENT)
    public static MachineSound scanningSound;

    public MatterScanner(String name) {
        super(name);
    }

    public static IMatterDatabase getLink(World world, ItemStack scanner) {
        BlockPos pos;
        TileEntity e;
        if (!scanner.func_190926_b() && scanner.func_77973_b() instanceof MatterScanner && scanner.func_77942_o() && scanner.func_77978_p().func_74767_n("isLinked") && (e = world.func_175625_s(pos = BlockPos.func_177969_a((long)scanner.func_77978_p().func_74763_f("link")))) instanceof IMatterDatabase) {
            return (IMatterDatabase)e;
        }
        return null;
    }

    public static BlockPos getLinkPosition(ItemStack scanner) {
        if (!scanner.func_190926_b() && scanner.func_77973_b() instanceof MatterScanner && scanner.func_77942_o()) {
            return new BlockPos(scanner.func_77978_p().func_74762_e("link_x"), scanner.func_77978_p().func_74762_e("link_y"), scanner.func_77978_p().func_74762_e("link_z"));
        }
        return new BlockPos(0, 0, 0);
    }

    public static boolean isLinked(ItemStack scanner) {
        if (!scanner.func_190926_b() && scanner.func_77973_b() instanceof MatterScanner && scanner.func_77942_o()) {
            return scanner.func_77978_p().func_74767_n("isLinked");
        }
        return false;
    }

    public static void unLink(World world, ItemStack scanner) {
        if (scanner.func_77942_o()) {
            scanner.func_77978_p().func_74757_a("isLinked", false);
        }
    }

    public static void link(World world, BlockPos pos, ItemStack scanner) {
        if (scanner.func_77973_b() instanceof MatterScanner) {
            ((MatterScanner)scanner.func_77973_b()).TagCompountCheck(scanner);
        }
        if (scanner.func_77942_o()) {
            scanner.func_77978_p().func_74757_a("isLinked", true);
            scanner.func_77978_p().func_74772_a("link", pos.func_177986_g());
        }
    }

    public static void setSelected(World world, ItemStack scanner, ItemStack itemStack) {
        if (scanner.func_77942_o()) {
            ItemPattern itemPattern = MatterScanner.getSelectedFromDatabase(world, scanner, itemStack);
            if (itemPattern == null) {
                itemPattern = new ItemPattern(itemStack);
            }
            MatterScanner.setSelected(scanner, itemPattern);
        }
    }

    public static void setSelected(ItemStack scanner, ItemPattern itemPattern) {
        if (scanner.func_77942_o()) {
            NBTTagCompound seletedNBT = new NBTTagCompound();
            itemPattern.writeToNBT(seletedNBT);
            scanner.func_77978_p().func_74782_a(SELECTED_TAG_NAME, (NBTBase)seletedNBT);
        }
    }

    public static ItemPattern getSelectedAsPattern(ItemStack scanner) {
        if (scanner.func_77942_o() && scanner.func_77978_p().func_74764_b(SELECTED_TAG_NAME)) {
            return new ItemPattern(scanner.func_77978_p().func_74775_l(SELECTED_TAG_NAME));
        }
        return null;
    }

    public static ItemStack getSelectedAsItem(ItemStack scanner) {
        if (scanner.func_77942_o()) {
            return new ItemPattern(scanner.func_77978_p().func_74775_l(SELECTED_TAG_NAME)).toItemStack(false);
        }
        return null;
    }

    public static ItemPattern getSelectedFromDatabase(World world, ItemStack scanner, ItemStack forItem) {
        IMatterDatabase database = MatterScanner.getLink(world, scanner);
        if (database != null) {
            return database.getPattern(forItem);
        }
        return null;
    }

    public static int getLastPage(ItemStack scanner) {
        if (scanner.func_77942_o()) {
            return scanner.func_77978_p().func_74765_d(PAGE_TAG_NAME);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.hasDetails(itemstack)) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addDetails(itemstack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, worldIn, tooltip);
            } else {
                tooltip.add(MOStringHelper.MORE_INFO);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        if (MatterScanner.isLinked(itemstack)) {
            infos.add(TextFormatting.GREEN + "Online");
            ItemPattern lastSelected = MatterScanner.getSelectedAsPattern(itemstack);
            if (lastSelected != null) {
                infos.add("Progress: " + lastSelected.getProgress() + " / " + 100 + " %");
                infos.add("Selected: " + lastSelected.getDisplayName());
            }
        } else {
            infos.add(TextFormatting.RED + "Offline");
        }
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public int getItemStackLimit(ItemStack item) {
        return 1;
    }

    private void resetScanProgress(ItemStack item) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74768_a("scan_progress", 0);
        }
    }

    private boolean HarvestBlock(ItemStack scanner, EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            return world.func_175698_g(pos);
        }
        return false;
    }

    @Override
    public void InitTagCompount(ItemStack stack) {
        MatterDatabaseHelper.initTagCompound(stack);
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack scanner) {
        ItemStack selected = MatterScanner.getSelectedAsItem(scanner);
        if (selected != null && MatterHelper.CanScan(selected)) {
            return 60 + MatterHelper.getMatterAmountFromItem(selected);
        }
        return Integer.MAX_VALUE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        RayTraceResult hit = this.getScanningPos(itemStackIn, (EntityLivingBase)playerIn);
        if (hit != null && hit.field_72313_a != RayTraceResult.Type.MISS) {
            if (worldIn.field_72995_K) {
                this.playSound(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
            }
            playerIn.func_184598_c(hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        EntityPlayer player;
        super.func_77663_a(itemStack, world, entity, p_77663_4_, p_77663_5_);
        if (world.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_184587_cr()) {
            this.stopScanSounds();
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        if (worldIn.field_72995_K) {
            this.stopScanSounds();
            return stack;
        }
        RayTraceResult position = this.getScanningPos(stack, entityLiving);
        if (position != null && position.field_72313_a == RayTraceResult.Type.BLOCK && !worldIn.field_72995_K) {
            ItemStack worldItem = MatterDatabaseHelper.GetItemStackFromWorld(worldIn, position.func_178782_a());
            if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventScan((EntityPlayer)entityLiving, stack, position))) {
                this.Scan(worldIn, stack, (EntityPlayer)entityLiving, worldItem, position.func_178782_a());
            }
        }
        return stack;
    }

    @Override
    public RayTraceResult getScanningPos(ItemStack itemStack, EntityLivingBase player) {
        return MOPhysicsHelper.rayTrace(player, player.field_70170_p, 5.0, 0.0f, new Vec3d(0.0, (double)player.func_70047_e(), 0.0), true, false);
    }

    @Override
    public boolean destroysBlocks(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean showsGravitationalWaves(ItemStack itemStack) {
        return false;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (MatterScanner.isLinked(stack)) {
            RayTraceResult hit = this.getScanningPos(stack, player);
            if (hit != null) {
                if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                    ItemStack lastSelected = MatterScanner.getSelectedAsItem(stack);
                    ItemStack worldItem = MatterDatabaseHelper.GetItemStackFromWorld(player.field_70170_p, hit.func_178782_a());
                    if (worldItem != null && !MatterDatabaseHelper.areEqual(lastSelected, worldItem)) {
                        MatterScanner.setSelected(player.field_70170_p, stack, worldItem);
                        player.func_184602_cy();
                        if (player.field_70170_p.field_72995_K) {
                            this.stopScanSounds();
                        }
                    }
                }
            } else if (player.field_70170_p.field_72995_K) {
                this.stopScanSounds();
                player.func_184602_cy();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(double x, double y, double z) {
        if (scanningSound == null) {
            scanningSound = new MachineSound(MatterOverdriveSounds.scannerScanning, SoundCategory.PLAYERS, new BlockPos(x, y, z), 0.6f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)scanningSound);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (worldIn.field_72995_K) {
            this.stopScanSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopScanSounds() {
        if (scanningSound != null) {
            scanningSound.stopPlaying();
            scanningSound = null;
        }
    }

    public boolean Scan(World world, ItemStack scanner, EntityPlayer player, ItemStack worldBlock, BlockPos pos) {
        this.TagCompountCheck(scanner);
        StringBuilder scanInfo = new StringBuilder();
        IMatterDatabase database = MatterScanner.getLink(world, scanner);
        if (database != null && MatterHelper.CanScan(worldBlock)) {
            this.resetScanProgress(scanner);
            if (database.addItem(worldBlock, 10, false, scanInfo)) {
                SoundHandler.PlaySoundAt(world, MatterOverdriveSounds.scannerSuccess, SoundCategory.PLAYERS, (Entity)player);
                this.DisplayInfo(player, scanInfo, TextFormatting.GREEN);
                return this.HarvestBlock(scanner, player, world, pos);
            }
            this.DisplayInfo(player, scanInfo, TextFormatting.RED);
            SoundHandler.PlaySoundAt(world, MatterOverdriveSounds.scannerFail, SoundCategory.PLAYERS, (Entity)player);
            return false;
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof IScannable) {
            ((IScannable)world.func_180495_p(pos).func_177230_c()).onScan(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player, scanner);
            return true;
        }
        if (world.func_175625_s(pos) instanceof IScannable) {
            ((IScannable)world.func_180495_p(pos).func_177230_c()).onScan(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player, scanner);
            return true;
        }
        return false;
    }

    private void DisplayInfo(EntityPlayer player, StringBuilder scanInfo, TextFormatting formatting) {
        if (player != null && !scanInfo.toString().isEmpty()) {
            player.func_146105_b((ITextComponent)new TextComponentString(formatting + scanInfo.toString()), true);
        }
    }
}

