/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.matter_network;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import matteroverdrive.api.transport.IGridNetwork;
import matteroverdrive.api.transport.IGridNode;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class GridNetworkHandler<K extends IGridNode, T extends IGridNetwork<K>> {
    public Stack<T> networkPool = new Stack();
    public Set<T> activeNetworkList = new HashSet<T>();

    public void recycleNetwork(T network) {
        this.networkPool.push(network);
        this.activeNetworkList.remove(network);
    }

    public abstract T createNewNetwork(K var1);

    public T getNetwork(K node) {
        Object network = this.networkPool.isEmpty() ? this.createNewNetwork(node) : (IGridNetwork)this.networkPool.pop();
        this.activeNetworkList.add(network);
        return network;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unload) {
        if (!unload.getWorld().field_72995_K && unload.getWorld().field_73011_w.getDimension() == 0) {
            this.activeNetworkList.forEach(IGridNetwork::recycle);
            this.activeNetworkList.clear();
        }
    }
}

