/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.IEnergyStorage;

public class MOElementEnergy
extends MOElementBase {
    protected int energyRequired;
    protected int energyRequiredPerTick;
    protected IEnergyStorage storage;
    protected boolean alwaysShowMinimum = false;

    public MOElementEnergy(MOGuiBase gui, int posX, int posY, IEnergyStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.setTexture("matteroverdrive:textures/gui/elements/fe.png", 32, 64);
        this.sizeX = 16;
        this.sizeY = 42;
        this.texW = 32;
        this.texH = 64;
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        if (this.storage.getMaxEnergyStored() < 0) {
            list.add("Infinite " + MOEnergyHelper.ENERGY_UNIT);
        } else {
            list.add(this.storage.getEnergyStored() + " / " + this.storage.getMaxEnergyStored() + MOEnergyHelper.ENERGY_UNIT);
        }
        if (this.energyRequired > 0) {
            list.add(TextFormatting.GREEN + "+" + String.valueOf(this.energyRequired) + MOEnergyHelper.ENERGY_UNIT + TextFormatting.RESET);
        } else if (this.energyRequired < 0) {
            list.add(TextFormatting.RED + String.valueOf(this.energyRequired) + MOEnergyHelper.ENERGY_UNIT + TextFormatting.RESET);
        }
        if (this.energyRequiredPerTick > 0) {
            list.add(TextFormatting.GREEN + "+" + String.valueOf(this.energyRequiredPerTick) + MOEnergyHelper.ENERGY_UNIT + "/t" + TextFormatting.RESET);
        } else if (this.energyRequiredPerTick < 0) {
            list.add(TextFormatting.RED + String.valueOf(this.energyRequiredPerTick) + MOEnergyHelper.ENERGY_UNIT + "/t" + TextFormatting.RESET);
        }
    }

    @Override
    public void drawBackground(int var1, int var2, float var3) {
        int var4 = this.getScaled();
        RenderUtils.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        this.drawTexturedModalRect(this.posX, this.posY + 42 - var4, 16, 42 - var4, this.sizeX, var4);
    }

    @Override
    public void drawForeground(int var1, int var2) {
    }

    protected int getScaled() {
        if (this.storage.getMaxEnergyStored() <= 0) {
            return this.sizeY;
        }
        long var1 = (long)this.storage.getEnergyStored() * (long)this.sizeY / (long)this.storage.getMaxEnergyStored();
        return this.alwaysShowMinimum && this.storage.getEnergyStored() > 0 ? (int)Math.max(1L, Math.round((double)var1)) : (int)Math.round((double)var1);
    }

    public int getEnergyRequired() {
        return this.energyRequired;
    }

    public void setEnergyRequired(int energyRequired) {
        this.energyRequired = energyRequired;
    }

    public int getEnergyRequiredPerTick() {
        return this.energyRequiredPerTick;
    }

    public void setEnergyRequiredPerTick(int energyRequired) {
        this.energyRequiredPerTick = energyRequired;
    }
}

