/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import java.util.Random;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;

public class MOElementButton
extends MOElementBase {
    public static final ScaleTexture NORMAL_TEXTURE = new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/button_normal.png"), 18, 18).setOffsets(7, 7, 7, 7);
    public static final ScaleTexture HOVER_TEXTURE = new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/button_over.png"), 18, 18).setOffsets(7, 7, 7, 7);
    public static final ScaleTexture HOVER_TEXTURE_DARK = new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/elements/button_over_dark.png"), 18, 18).setOffsets(7, 7, 7, 7);
    public static final Random rand = new Random();
    protected ResourceLocation[] sounds = new ResourceLocation[]{new ResourceLocation("matteroverdrive", "button_soft")};
    protected String text;
    protected boolean isDown;
    protected int lastMouseButton;
    protected Color color;
    int labelColor = -1;
    IButtonHandler buttonHandler;
    HoloIcon icon;
    private int hoverX;
    private int hoverY;
    private int sheetX;
    private int sheetY;
    private int disabledX;
    private int disabledY;
    private String tooltip;

    public MOElementButton(MOGuiBase gui, IButtonHandler handler, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, String texture) {
        this(gui, handler, posX, posY, name, sheetX, sheetY, hoverX, hoverY, 0, 0, sizeX, sizeY, texture);
    }

    public MOElementButton(MOGuiBase gui, IButtonHandler handler, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY, sizeX, sizeY);
        this.buttonHandler = handler;
        this.name = name;
        this.buttonHandler = handler;
        this.sheetX = sheetX;
        this.sheetY = sheetY;
        this.hoverX = hoverX;
        this.hoverY = hoverY;
        this.disabledX = disabledX;
        this.disabledY = disabledY;
        this.setTexture(texture, this.texH, this.texW);
    }

    @Override
    public boolean onMousePressed(int x, int y, int mouseButton) {
        if (this.isEnabled()) {
            this.isDown = true;
            this.lastMouseButton = mouseButton;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        if (this.isEnabled() && this.intersectsWith(mouseX, mouseY) && this.isDown) {
            SoundEvent sound = this.getSound();
            if (sound != null) {
                MOGuiBase.playSound(sound, this.getSoundVolume(), 0.9f + rand.nextFloat() * 0.2f);
            }
            this.onAction(mouseX, mouseY, this.lastMouseButton);
        }
        this.isDown = false;
    }

    public SoundEvent getSound() {
        if (this.sounds != null && this.sounds.length > 0 && SoundEvent.field_187505_a.func_148741_d((Object)this.sounds[rand.nextInt(this.sounds.length)])) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)this.sounds[rand.nextInt(this.sounds.length)]);
        }
        return null;
    }

    public void setSounds(ResourceLocation ... sounds) {
        this.sounds = sounds;
    }

    public float getSoundVolume() {
        return 0.5f;
    }

    public void onAction(int mouseX, int mouseY, int mouseButton) {
        this.buttonHandler.handleElementButtonClick(this, this.getName(), this.lastMouseButton);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.color != null) {
            RenderUtils.applyColor(this.color);
        }
        GL11.glEnable((int)3042);
        RenderUtils.bindTexture(this.texture);
        if (this.isEnabled()) {
            if (this.intersectsWith(mouseX, mouseY)) {
                this.drawTexturedModalRect(this.posX, this.posY, this.hoverX, this.hoverY, this.sizeX, this.sizeY);
            } else {
                this.drawTexturedModalRect(this.posX, this.posY, this.sheetX, this.sheetY, this.sizeX, this.sizeY);
            }
        } else {
            this.drawTexturedModalRect(this.posX, this.posY, this.disabledX, this.disabledY, this.sizeX, this.sizeY);
        }
        GL11.glDisable((int)3042);
    }

    @Override
    public void drawForeground(int i, int i1) {
    }

    @Override
    public void addTooltip(List<String> var1, int mouseX, int mouseY) {
        if (this.tooltip != null) {
            var1.add(this.tooltip);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    public void setColor(Color color, float multiplay) {
        this.color = new Color((int)((float)color.getIntR() * multiplay), (int)((float)color.getIntG() * multiplay), (int)((float)color.getIntB() * multiplay));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    public int getTextColor() {
        return this.labelColor;
    }

    public void setTextColor(int color) {
        this.labelColor = color;
    }

    public HoloIcon getIcon() {
        return this.icon;
    }

    public void setIcon(HoloIcon icon) {
        this.icon = icon;
    }

    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
    }
}

