/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.IMOListBoxElement;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementListBox;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class ElementTaskList
extends MOElementListBox {
    MatterNetworkTaskQueue<? extends MatterNetworkTask> taskQueue;
    List<String> lastTooltip;
    IButtonHandler buttonHandler;

    public ElementTaskList(MOGuiBase gui, IButtonHandler buttonHandler, int posX, int posY, MatterNetworkTaskQueue<? extends MatterNetworkTask> taskQueue) {
        this(gui, buttonHandler, posX, posY, 0, 0, taskQueue);
    }

    public ElementTaskList(MOGuiBase gui, IButtonHandler buttonHandler, int posX, int posY, int width, int height, MatterNetworkTaskQueue<? extends MatterNetworkTask> taskQueue) {
        super(gui, posX, posY, width, height);
        this.taskQueue = taskQueue;
        this.lastTooltip = new ArrayList<String>();
        this.buttonHandler = buttonHandler;
    }

    @Override
    public int getElementCount() {
        return this.taskQueue.size();
    }

    @Override
    public int getElementHeight(int id) {
        if (this.getSelectedIndex() == id) {
            return 44;
        }
        return 22;
    }

    @Override
    public int getElementWidth(int id) {
        return 132;
    }

    @Override
    public IMOListBoxElement getElement(int index) {
        return null;
    }

    @Override
    public void DrawElement(int i, int x, int y, int selectedLineColor, int selectedTextColor, boolean selected, boolean BG) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (selected) {
            if (i == 0) {
                MOElementButton.NORMAL_TEXTURE.render(x, y, this.getElementWidth(i), this.getElementHeight(i));
            } else {
                MOElementButton.HOVER_TEXTURE.render(x, y, this.getElementWidth(i), this.getElementHeight(i));
                MOElementButton.HOVER_TEXTURE_DARK.render(x + 60, y + this.getElementHeight(i) / 2 - 2, 50, this.getElementHeight(i) / 2 - 4);
                Minecraft.func_71410_x().field_71466_p.func_175063_a("top", (float)(x + 76), (float)(y + 24), 0xFFFFFF);
            }
            MOElementButton.HOVER_TEXTURE_DARK.render(x + 6, y + this.getElementHeight(i) / 2 - 2, 50, this.getElementHeight(i) / 2 - 4);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("remove", (float)(x + 13), (float)(y + 24), 0xFFFFFF);
        } else if (i == 0) {
            MOElementButton.NORMAL_TEXTURE.render(x, y, this.getElementWidth(i), this.getElementHeight(i));
        } else {
            MOElementButton.HOVER_TEXTURE_DARK.render(x, y, this.getElementWidth(i), this.getElementHeight(i));
        }
        MatterNetworkTask task = this.taskQueue.getAt(i);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(task.getName(), (float)(x + 8), (float)(y + 7), 0xFFFFFF);
    }

    @Override
    public void drawElementTooltip(int index, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.posX), (float)0.0f, (float)0.0f);
        ArrayList<String> tooltip = new ArrayList<String>();
        this.taskQueue.getAt(index).addInfo(tooltip);
        this.gui.setTooltip(tooltip);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void onElementClicked(int index, int mouseX, int mouseY) {
        if (index != 0 && mouseY > 22 && mouseX > 60 && mouseX < 110) {
            return;
        }
        if (mouseY > 22 && mouseX < 50) {
            this.buttonHandler.handleElementButtonClick(this, "DropTask", index);
        }
    }
}

