/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ElementMatterStored
extends MOElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("matteroverdrive:textures/gui/elements/matter.png");
    public static final int DEFAULT_SCALE = 42;
    protected IMatterHandler storage;
    protected boolean alwaysShowMinimum = false;
    private int drain = 0;
    private double drainPerTick = 0.0;

    public ElementMatterStored(MOGuiBase gui, int posX, int posY, IMatterHandler storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.texture = DEFAULT_TEXTURE;
        this.sizeX = 16;
        this.sizeY = 42;
        this.texW = 32;
        this.texH = 64;
    }

    public ElementMatterStored setAlwaysShow(boolean show) {
        this.alwaysShowMinimum = show;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int amount = this.getScaled();
        RenderUtils.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        this.drawTexturedModalRect(this.posX, this.posY + 42 - amount, 16, 42 - amount, this.sizeX, amount);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        if (this.storage.getCapacity() < 0) {
            list.add("Infinite  kM");
        } else {
            list.add(this.storage.getMatterStored() + " / " + this.storage.getCapacity() + " kM");
        }
        if (this.drain > 0) {
            list.add(TextFormatting.GREEN + "+" + MatterHelper.formatMatter(this.drain));
        } else if (this.drain < 0) {
            list.add(TextFormatting.RED + MatterHelper.formatMatter(this.drain));
        }
        if (this.drainPerTick > 0.0) {
            list.add(TextFormatting.GREEN + "+" + MatterHelper.formatMatter(this.drainPerTick) + "/t");
        } else if (this.drainPerTick < 0.0) {
            list.add(TextFormatting.RED + MatterHelper.formatMatter(this.drainPerTick) + "/t");
        }
    }

    protected int getScaled() {
        if (this.storage.getCapacity() <= 0) {
            return this.sizeY;
        }
        long fraction = (long)this.storage.getMatterStored() * (long)this.sizeY / (long)this.storage.getCapacity();
        return this.alwaysShowMinimum && this.storage.getMatterStored() > 0 ? Math.max(1, Math.round(fraction)) : Math.round(fraction);
    }

    public void setDrain(int amount) {
        this.drain = amount;
    }

    public void setDrainPerTick(double amount) {
        this.drainPerTick = amount;
    }
}

