/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import matteroverdrive.Reference;
import matteroverdrive.container.ContainerMachine;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.data.inventory.UpgradeSlot;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementIndicator;
import matteroverdrive.gui.element.ElementSlotsList;
import matteroverdrive.gui.pages.AutoConfigPage;
import matteroverdrive.gui.pages.PageUpgrades;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;

public class MOGuiMachine<T extends MOTileEntityMachine>
extends MOGuiBase {
    T machine;
    ElementSlotsList slotsList;
    ElementIndicator indicator;

    public MOGuiMachine(ContainerMachine<T> container, T machine) {
        this(container, machine, 225, 186);
    }

    public MOGuiMachine(ContainerMachine<T> container, T machine, int width, int height) {
        super(container, width, height);
        this.machine = machine;
        this.indicator = new ElementIndicator(this, 6, this.field_147000_g - 18);
        this.slotsList = new ElementSlotsList(this, 5, 52, 80, 200, ((MOTileEntityMachine)machine).getInventoryContainer(), 0);
        this.slotsList.setMargin(5);
        this.registerPages(container, machine);
    }

    public void registerPages(MOBaseContainer container, T machine) {
        ElementBaseGroup homePage = new ElementBaseGroup(this, 0, 0, this.field_146999_f, this.field_147000_g);
        homePage.setName("Home");
        AutoConfigPage configPage = new AutoConfigPage(this, 48, 32, this.field_146999_f - 76, this.field_147000_g);
        configPage.setName("Configurations");
        this.AddPage(homePage, ClientProxy.holoIcons.getIcon("page_icon_home"), MOStringHelper.translateToLocal("gui.tooltip.page.home", new Object[0])).setIconColor(Reference.COLOR_MATTER);
        this.AddPage(configPage, ClientProxy.holoIcons.getIcon("page_icon_config"), MOStringHelper.translateToLocal("gui.tooltip.page.configurations", new Object[0]));
        boolean hasUpgrades = false;
        for (Slot slot : ((MOTileEntityMachine)machine).getInventoryContainer().getSlots()) {
            if (!(slot instanceof UpgradeSlot)) continue;
            hasUpgrades = true;
        }
        if (hasUpgrades) {
            PageUpgrades upgradesPage = new PageUpgrades(this, 0, 0, this.field_146999_f, this.field_147000_g, container);
            upgradesPage.setName("Upgrades");
            this.AddPage(upgradesPage, ClientProxy.holoIcons.getIcon("page_icon_upgrades"), MOStringHelper.translateToLocal("gui.tooltip.page.upgrades", new Object[0]));
        }
        this.setPage(0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement(this.slotsList);
        this.addElement(this.indicator);
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        if (((MOTileEntityMachine)this.machine).isActive()) {
            this.indicator.setIndication(1);
        } else {
            this.indicator.setIndication(0);
        }
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.name != null && !this.name.isEmpty()) {
            String n = MOStringHelper.translateToLocal("gui." + this.name + ".name", new Object[0]);
            this.field_146289_q.func_78276_b(n, 11 + this.field_146999_f / 2 - this.field_146289_q.func_78256_a(n) / 2, 7, Reference.COLOR_MATTER.getColor());
        }
        this.drawElements(0.0f, true);
    }

    public T getMachine() {
        return this.machine;
    }
}

