/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.animation.AnimationSegmentText;
import matteroverdrive.animation.AnimationTextTyping;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.gui.GuiDialog;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.android.AndroidHudBionicStats;
import matteroverdrive.gui.android.AndroidHudMinimap;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.gui.android.AndroidHudStats;
import matteroverdrive.gui.android.IAndroidHudElement;
import matteroverdrive.gui.config.EnumConfigProperty;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiAndroidHud
extends Gui
implements IConfigSubscriber {
    public static final ResourceLocation glitch_tex = new ResourceLocation("matteroverdrive:textures/gui/glitch.png");
    public static final ResourceLocation spinner_tex = new ResourceLocation("matteroverdrive:textures/gui/elements/spinner.png");
    public static final ResourceLocation top_element_bg = new ResourceLocation("matteroverdrive:textures/gui/elements/android_bg_element.png");
    public static final ResourceLocation cloak_overlay = new ResourceLocation("matteroverdrive:textures/gui/elements/cloak_overlay.png");
    public static boolean showRadial = false;
    public static double radialDeltaX;
    public static double radialDeltaY;
    public static double radialAngle;
    public static float hudRotationYawSmooth;
    public static float hudRotationPitchSmooth;
    private static double radialAnimationTime;
    public final AndroidHudMinimap hudMinimap;
    public final AndroidHudStats hudStats;
    public final AndroidHudBionicStats bionicStats;
    private final Minecraft mc;
    private final Random random;
    private final List<IBioticStat> stats = new ArrayList<IBioticStat>();
    private final List<IAndroidHudElement> hudElements;
    public Color baseGuiColor;
    public float opacity;
    public float opacityBackground;
    public boolean hideVanillaHudElements;
    public boolean hudMovement;
    private AnimationTextTyping textTyping;
    private ShaderGroup hurtShader;
    private HoloIcon crosshairIcon;

    public GuiAndroidHud(Minecraft mc) {
        String info;
        this.mc = mc;
        this.random = new Random();
        this.textTyping = new AnimationTextTyping(false, 680);
        for (int i = 0; i < 5; ++i) {
            info = MOStringHelper.translateToLocal("gui.android_hud.transforming.line." + i, new Object[0]);
            this.textTyping.addSegmentSequential(new AnimationSegmentText(info, 0, 1).setLengthPerCharacter(2));
            this.textTyping.addSegmentSequential(new AnimationSegmentText(info, 0, 0).setLengthPerCharacter(2));
        }
        info = MOStringHelper.translateToLocal("gui.android_hud.transforming.line.final", new Object[0]);
        this.textTyping.addSegmentSequential(new AnimationSegmentText(info, 0, 1).setLengthPerCharacter(2));
        this.textTyping.addSegmentSequential(new AnimationSegmentText(info, 680, 0));
        this.hudElements = new ArrayList<IAndroidHudElement>();
        this.hudMinimap = new AndroidHudMinimap(AndroidHudPosition.BOTTOM_LEFT, "android_minimap");
        this.hudStats = new AndroidHudStats(AndroidHudPosition.TOP_LEFT, "android_stats");
        this.bionicStats = new AndroidHudBionicStats(AndroidHudPosition.TOP_RIGHT, "android_biotic_stats");
        this.hudElements.add(this.hudMinimap);
        this.hudElements.add(this.hudStats);
        this.hudElements.add(this.bionicStats);
        this.baseGuiColor = Reference.COLOR_HOLO.multiplyWithoutAlpha(0.5f);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (showRadial) {
            Mouse.getDX();
            Mouse.getDY();
            this.mc.field_71417_B.field_74375_b = 0;
            this.mc.field_71417_B.field_74377_a = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (this.mc.field_71439_g.func_175149_v()) {
            return;
        }
        AndroidPlayer android = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)this.mc.field_71439_g);
        if ((this.mc.field_71462_r instanceof GuiDialog || this.mc.field_71462_r instanceof GuiStarMap) && !event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL) && event.isCancelable()) {
            event.setCanceled(true);
            return;
        }
        if (android.isAndroid() && event.isCancelable() && this.hideVanillaHudElements) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
                event.setCanceled(true);
                return;
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && android.isUnlocked(OverdriveBioticStats.oxygen, 1) && OverdriveBioticStats.oxygen.isEnabled(android, 1)) {
                event.setCanceled(true);
                return;
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && android.isUnlocked(OverdriveBioticStats.zeroCalories, 1) && OverdriveBioticStats.zeroCalories.isEnabled(android, 1)) {
                event.setCanceled(true);
                return;
            }
        }
        if ((android.isAndroid() || !this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) && event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (!showRadial) {
                this.renderCrosshair(event);
            }
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            this.renderHud(event);
            if (android.isAndroid() && (radialAnimationTime = showRadial ? Math.min(1.0, radialAnimationTime + (double)event.getPartialTicks() * 0.2) : Math.max(0.0, radialAnimationTime - (double)event.getPartialTicks() * 0.2)) > 0.0) {
                this.renderRadialMenu(event);
            }
        }
    }

    public void renderCrosshair(RenderGameOverlayEvent event) {
        GlStateManager.func_179094_E();
        float scale = 6.0f + ClientProxy.instance().getClientWeaponHandler().getEquippedWeaponAccuracyPercent((EntityPlayer)Minecraft.func_71410_x().field_71439_g) * 256.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.crosshairIcon = ClientProxy.holoIcons.getIcon("crosshair");
        GlStateManager.func_179109_b((float)(event.getResolution().func_78326_a() / 2), (float)(event.getResolution().func_78328_b() / 2), (float)0.0f);
        ClientProxy.holoIcons.bindSheet();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ClientProxy.holoIcons.renderIcon(this.crosshairIcon, -1.0, (double)(-scale));
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ClientProxy.holoIcons.renderIcon(this.crosshairIcon, -2.0, (double)(-scale));
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ClientProxy.holoIcons.renderIcon(this.crosshairIcon, -1.8, (double)(-scale + 1.0f));
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ClientProxy.holoIcons.renderIcon(this.crosshairIcon, -1.0, (double)(-scale + 1.0f));
        GlStateManager.func_179121_F();
    }

    public void renderRadialMenu(RenderGameOverlayEvent event) {
        if (this.mc.field_71439_g.func_175149_v()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(event.getResolution().func_78326_a() / 2), (float)(event.getResolution().func_78328_b() / 2), (float)0.0f);
        double scale = MOMathHelper.easeIn(radialAnimationTime, 0.0, 1.0, 1.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        ClientProxy.holoIcons.bindSheet();
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)Minecraft.func_71410_x().field_71439_g);
        this.stats.clear();
        for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
            if (!stat.showOnWheel(androidPlayer, androidPlayer.getUnlockedLevel(stat)) || !androidPlayer.isUnlocked(stat, 0)) continue;
            this.stats.add(stat);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)radialAngle), (float)0.0f, (float)0.0f, (float)-1.0f);
        RenderUtils.applyColorWithAlpha(this.baseGuiColor, 1.0f);
        ClientProxy.holoIcons.renderIcon("up_arrow_large", -9.0, -50.0);
        GlStateManager.func_179121_F();
        int i = 0;
        for (IBioticStat stat : this.stats) {
            double angleCircle;
            double angleAb;
            int c;
            double angleSeg = Math.PI * 2 / (double)this.stats.size();
            double radius = 80.0;
            double angle = angleSeg * (double)i;
            angle += Math.toRadians(180.0);
            double radiusMin = radius - 16.0;
            double radiusMax = radius + 16.0;
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (stat.equals(androidPlayer.getActiveStat())) {
                radiusMax = radius + 20.0;
                radiusMin = radius - 16.0;
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
            } else {
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            for (c = 0; c < 32; ++c) {
                angleAb = angleSeg / 32.0;
                angleCircle = (double)c * angleAb + angle - angleSeg / 2.0;
                wr.func_181662_b(Math.sin(angleCircle) * radiusMax, Math.cos(angleCircle) * radiusMax, -1.0).func_181675_d();
                wr.func_181662_b(Math.sin(angleCircle + angleAb) * radiusMax, Math.cos(angleCircle + angleAb) * radiusMax, -1.0).func_181675_d();
                wr.func_181662_b(Math.sin(angleCircle + angleAb) * radiusMin, Math.cos(angleCircle + angleAb) * radiusMin, -1.0).func_181675_d();
                wr.func_181662_b(Math.sin(angleCircle) * radiusMin, Math.cos(angleCircle) * radiusMin, -1.0).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            radiusMax = radius - 20.0;
            radiusMin = radius - 25.0;
            wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
            for (c = 0; c < 32; ++c) {
                angleAb = 0.19634954084936207;
                angleCircle = (double)c * angleAb;
                wr.func_181662_b(Math.sin(angleCircle) * radiusMax, Math.cos(angleCircle) * radiusMax, -1.0).func_181675_d();
                wr.func_181662_b(Math.sin(angleCircle + angleAb) * radiusMax, Math.cos(angleCircle + angleAb) * radiusMax, -1.0).func_181675_d();
                wr.func_181662_b(Math.sin(angleCircle + angleAb) * radiusMin, Math.cos(angleCircle + angleAb) * radiusMin, -1.0).func_181675_d();
                wr.func_181662_b(Math.sin(angleCircle) * radiusMin, Math.cos(angleCircle) * radiusMin, -1.0).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
            ClientProxy.holoIcons.bindSheet();
            if (androidPlayer.getActiveStat() != null) {
                double y;
                double x;
                if (stat.equals(androidPlayer.getActiveStat())) {
                    RenderUtils.applyColorWithMultipy(this.baseGuiColor, 1.0f);
                    x = Math.sin(angle) * radius;
                    y = Math.cos(angle) * radius;
                    ClientProxy.holoIcons.renderIcon(stat.getIcon(0), -12.0 + x, -12.0 + y);
                    String statName = stat.getDisplayName(androidPlayer, androidPlayer.getUnlockedLevel(stat));
                    int statNameWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(statName);
                    GlStateManager.func_179112_b((int)770, (int)771);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(statName, -statNameWidth / 2, -5, Reference.COLOR_HOLO.getColor());
                } else {
                    x = Math.sin(angle) * radius;
                    y = Math.cos(angle) * radius;
                    RenderUtils.applyColorWithMultipy(this.baseGuiColor, 0.8f);
                    ClientProxy.holoIcons.renderIcon(stat.getIcon(0), -12.0 + x, -12.0 + y);
                }
            }
            ++i;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    public void renderHud(RenderGameOverlayEvent event) {
        if (this.mc.field_71439_g.func_175149_v()) {
            return;
        }
        AndroidPlayer android = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)this.mc.field_71439_g);
        if (android != null) {
            if (android.isAndroid()) {
                GlStateManager.func_179094_E();
                if (OverdriveBioticStats.cloak.isActive(android, 0)) {
                    GlStateManager.func_179112_b((int)774, (int)0);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    this.mc.field_71446_o.func_110577_a(cloak_overlay);
                    RenderUtils.drawPlane(0.0, 0.0, -100.0, event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
                }
                if (this.hudMovement && !this.mc.field_71439_g.func_70608_bn()) {
                    hudRotationYawSmooth = this.mc.field_71439_g.field_71163_h + (this.mc.field_71439_g.field_71154_f - this.mc.field_71439_g.field_71163_h) * event.getPartialTicks();
                    hudRotationPitchSmooth = this.mc.field_71439_g.field_71164_i + (this.mc.field_71439_g.field_71155_g - this.mc.field_71439_g.field_71164_i) * event.getPartialTicks();
                    GlStateManager.func_179109_b((float)((hudRotationYawSmooth - this.mc.field_71439_g.field_70177_z) * 0.2f), (float)((hudRotationPitchSmooth - this.mc.field_71439_g.field_70125_A) * 0.2f), (float)0.0f);
                }
                for (IAndroidHudElement element : this.hudElements) {
                    if (!element.isVisible(android)) continue;
                    GlStateManager.func_179094_E();
                    int elementWidth = (int)((float)element.getWidth(event.getResolution(), android) * element.getPosition().x);
                    GlStateManager.func_179137_b((double)((double)element.getPosition().x * event.getResolution().func_78327_c() - (double)elementWidth), (double)((double)element.getPosition().y * event.getResolution().func_78324_d() - (double)((float)element.getHeight(event.getResolution(), android) * element.getPosition().y)), (double)0.0);
                    element.setBaseColor(this.baseGuiColor);
                    element.setBackgroundAlpha(this.opacityBackground);
                    element.drawElement(android, event.getResolution(), event.getPartialTicks());
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179121_F();
                this.renderHurt(android, event);
            } else if (android.isTurning()) {
                this.renderTransformAnimation(android, event);
            }
        }
    }

    private void renderTransformAnimation(AndroidPlayer player, RenderGameOverlayEvent event) {
        int centerX = event.getResolution().func_78326_a() / 2;
        int centerY = event.getResolution().func_78328_b() / 2 - 30;
        int maxTime = 680;
        int time = maxTime - player.getAndroidEffects().getEffectShort(9);
        this.textTyping.setTime(time);
        if (time % 40 > 0 && time % 40 < 3) {
            this.renderGlitch(player, event);
        }
        String info = this.textTyping.getString();
        int width = this.mc.field_71466_p.func_78256_a(info);
        this.mc.field_71466_p.func_78276_b(info, centerX - width / 2, centerY - 28, Reference.COLOR_HOLO.getColor());
        this.mc.field_71446_o.func_110577_a(spinner_tex);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)centerX, (float)centerY, (float)0.0f);
        GlStateManager.func_179114_b((float)(this.mc.field_71441_e.func_72820_D() * 10L), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)-16.0f, (float)-16.0f, (float)0.0f);
        GuiAndroidHud.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        GlStateManager.func_179121_F();
        this.mc.field_71466_p.func_78276_b(Math.round(this.textTyping.getPercent() * 100.0) + "%", centerX - 6, centerY - 3, Reference.COLOR_HOLO.getColor());
    }

    public void renderHurt(AndroidPlayer player, RenderGameOverlayEvent event) {
        if (player.getAndroidEffects().getEffectInt(0) > 0) {
            this.renderGlitch(player, event);
        }
    }

    public void renderGlitch(AndroidPlayer player, RenderGameOverlayEvent event) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179097_i();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(glitch_tex);
        RenderUtils.drawPlaneWithUV(0.0, 0.0, -100.0, event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), this.random.nextGaussian(), this.random.nextGaussian(), 1.0, 1.0);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        Property prop = config.config.get("client.android_hud", this.hudMinimap.getName() + ".position", this.hudMinimap.getDefaultPosition().ordinal());
        prop.setConfigEntryClass(EnumConfigProperty.class);
        prop.setValidValues(AndroidHudPosition.getNames());
        prop.setLanguageKey("config.android_hud.minimap.position");
        this.hudMinimap.setHudPosition(AndroidHudPosition.values()[prop.getInt()]);
        prop = config.config.get("client.android_hud", this.hudStats.getName() + ".position", this.hudStats.getDefaultPosition().ordinal());
        prop.setConfigEntryClass(EnumConfigProperty.class);
        prop.setValidValues(AndroidHudPosition.getNames());
        prop.setLanguageKey("config.android_hud.stats.position");
        this.hudStats.setHudPosition(AndroidHudPosition.values()[prop.getInt()]);
        prop = config.config.get("client.android_hud", this.bionicStats.getName() + ".position", this.bionicStats.getDefaultPosition().ordinal());
        prop.setConfigEntryClass(EnumConfigProperty.class);
        prop.setValidValues(AndroidHudPosition.getNames());
        prop.setLanguageKey("config.android_hud.bionicStats.position");
        this.bionicStats.setHudPosition(AndroidHudPosition.values()[prop.getInt()]);
        Color color = Reference.COLOR_HOLO;
        prop = config.config.get("client.android_hud", "hud_color", Integer.toHexString(color.getColor()));
        prop.setLanguageKey("config.android_hud.color");
        try {
            this.baseGuiColor = new Color(Integer.parseInt(prop.getString(), 16));
        }
        catch (Exception e) {
            this.baseGuiColor = Reference.COLOR_HOLO;
        }
        prop = config.config.get("client.android_hud", "hud_opacity", 0.5, "The Opacity of the HUD in %", 0.0, 1.0);
        prop.setLanguageKey("config.android_hud.opacity");
        this.baseGuiColor = new Color(this.baseGuiColor.getIntR(), this.baseGuiColor.getIntG(), this.baseGuiColor.getIntB(), (int)(255.0 * prop.getDouble()));
        prop = config.config.get("client.android_hud", "hud_background_opacity", 0.0, "The opacity of the black background for each HUD element");
        prop.setLanguageKey("config.android_hud.opacity_background");
        this.opacityBackground = (float)prop.getDouble();
        prop = config.config.get("client.android_hud", "hide_vanilla_hud_elements", true, "Should the health bar and food bar be hidden");
        prop.setLanguageKey("config.android_hud.hide_vanilla");
        this.hideVanillaHudElements = prop.getBoolean();
        prop = config.config.get("client.android_hud", "hud_movement", true, "Should the Android HUD move when the player turns his head.");
        prop.setLanguageKey("config.android_hud.hud_movement");
        this.hudMovement = prop.getBoolean();
    }
}

