/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.world;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import net.minecraft.nbt.NBTTagCompound;

public class WorldPosition2D
implements Serializable {
    public int x;
    public int z;

    public WorldPosition2D(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public WorldPosition2D(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public WorldPosition2D(ByteBuf byteBuf) {
        this.readFromBuffer(byteBuf);
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("wp_x", this.x);
        tagCompound.func_74768_a("wp_z", this.z);
    }

    public void writeToBuffer(ByteBuf byteBuf) {
        byteBuf.writeInt(this.x);
        byteBuf.writeInt(this.z);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.x = tagCompound.func_74762_e("wp_x");
        this.z = tagCompound.func_74762_e("wp_z");
    }

    public void readFromBuffer(ByteBuf byteBuf) {
        this.x = byteBuf.readInt();
        this.z = byteBuf.readInt();
    }

    public int manhattanDistance(WorldPosition2D other) {
        return this.manhattanDistance(other.x, other.z);
    }

    public int manhattanDistance(int x, int z) {
        return Math.abs(this.x - x) + Math.abs(this.z - z);
    }

    public int hashCode() {
        return this.x & 0xFFF | this.z & 0xFF00;
    }
}

