/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.rewards;

import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOQuestHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Level;

public class EntityReward
implements IQuestReward {
    private String entityId;
    private int count;
    private boolean positionFromNbt;
    private Vec3d positionOffset;
    private NBTTagCompound nbtTagCompound;

    public EntityReward() {
    }

    public EntityReward(String entityId, int count) {
        this.entityId = entityId;
        this.count = count;
    }

    @Override
    public void loadFromJson(JsonObject object) {
        String positionType;
        this.entityId = MOJsonHelper.getString(object, "id");
        if (object.has("position") && (positionType = MOJsonHelper.getString(object, "position")).equalsIgnoreCase("nbt")) {
            this.positionFromNbt = true;
        }
        this.count = MOJsonHelper.getInt(object, "count");
        this.nbtTagCompound = MOJsonHelper.getNbt(object, "nbt", null);
        this.positionOffset = MOJsonHelper.getVec3(object, "offset", new Vec3d(0.0, 0.0, 0.0));
    }

    @Override
    public void giveReward(QuestStack questStack, EntityPlayer entityPlayer) {
        for (ResourceLocation key : EntityList.func_180124_b()) {
            MOLog.info(key.toString(), new Object[0]);
        }
        Class entityClass = EntityList.getClass((ResourceLocation)new ResourceLocation(this.entityId));
        EntityRegistry.EntityRegistration entityRegistration = EntityRegistry.instance().lookupModSpawn(entityClass, true);
        if (entityRegistration != null) {
            for (int i = 0; i < this.count; ++i) {
                try {
                    Constructor constructor = entityRegistration.getEntityClass().getConstructor(World.class);
                    Entity entity = (Entity)constructor.newInstance(entityPlayer.field_70170_p);
                    if (this.positionFromNbt) {
                        BlockPos pos = MOQuestHelper.getPosition(questStack);
                        if (pos != null) {
                            entity.func_70107_b((double)pos.func_177958_n() + this.positionOffset.field_72450_a, (double)pos.func_177956_o() + this.positionOffset.field_72448_b, (double)pos.func_177952_p() + this.positionOffset.field_72449_c);
                        } else {
                            entity.func_70107_b(entityPlayer.field_70165_t + this.positionOffset.field_72450_a, entityPlayer.field_70163_u + this.positionOffset.field_72448_b, entityPlayer.field_70161_v + this.positionOffset.field_72449_c);
                        }
                    } else {
                        entity.func_70107_b(entityPlayer.field_70165_t + this.positionOffset.field_72450_a, entityPlayer.field_70163_u + this.positionOffset.field_72448_b, entityPlayer.field_70161_v + this.positionOffset.field_72449_c);
                    }
                    if (this.nbtTagCompound != null) {
                        entity.func_70020_e(this.nbtTagCompound);
                    }
                    entityPlayer.field_70170_p.func_72838_d(entity);
                    continue;
                }
                catch (Exception e) {
                    MOLog.log(Level.WARN, e, "Could not spawn Entity reward of type %s for quest %s", entityRegistration.getEntityClass(), questStack.getTitle());
                }
            }
        } else {
            MOLog.warn("Could not find an entity of type %s while giving an entity reward for quest %s", this.entityId, questStack.getTitle());
        }
    }

    @Override
    public boolean isVisible(QuestStack questStack) {
        return false;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isPositionFromNbt() {
        return this.positionFromNbt;
    }

    public void setPositionFromNbt(boolean positionFromNbt) {
        this.positionFromNbt = positionFromNbt;
    }

    public Vec3d getPositionOffset() {
        return this.positionOffset;
    }

    public void setPositionOffset(Vec3d positionOffset) {
        this.positionOffset = positionOffset;
    }

    public NBTTagCompound getNbtTagCompound() {
        return this.nbtTagCompound;
    }

    public void setNbtTagCompound(NBTTagCompound nbtTagCompound) {
        this.nbtTagCompound = nbtTagCompound;
    }
}

