/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.exceptions.MOQuestParseException;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class QuestLogicKillCreature
extends AbstractQuestLogic {
    String regex;
    ItemStack killWithItemStack;
    Item killWithItem;
    boolean explosionOnly;
    boolean burnOnly;
    boolean shootOnly;
    boolean onlyChildren;
    int minKillCount;
    int maxKillCount;
    int xpPerKill;
    String[] creatureTypes;

    public QuestLogicKillCreature() {
    }

    public QuestLogicKillCreature(String creatureClass, int minKillCount, int maxKillCount, int xpPerKill) {
        this(new String[]{creatureClass}, minKillCount, maxKillCount, xpPerKill);
    }

    public QuestLogicKillCreature(String[] creatureTypes, int minKillCount, int maxKillCount, int xpPerKill) {
        this.creatureTypes = creatureTypes;
        this.minKillCount = minKillCount;
        this.maxKillCount = maxKillCount;
        this.xpPerKill = xpPerKill;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        this.regex = MOJsonHelper.getString(jsonObject, "regex", null);
        this.killWithItemStack = MOJsonHelper.getItemStack(jsonObject, "kill_item", null);
        this.explosionOnly = MOJsonHelper.getBool(jsonObject, "explosion_only", false);
        this.burnOnly = MOJsonHelper.getBool(jsonObject, "burn_only", false);
        this.shootOnly = MOJsonHelper.getBool(jsonObject, "shoot_only", false);
        this.onlyChildren = MOJsonHelper.getBool(jsonObject, "children_only", false);
        this.minKillCount = MOJsonHelper.getInt(jsonObject, "kill_count_min");
        this.minKillCount = MOJsonHelper.getInt(jsonObject, "kill_count_max");
        this.xpPerKill = MOJsonHelper.getInt(jsonObject, "xp");
        JsonArray creatureTypes = jsonObject.getAsJsonArray("creatures");
        this.creatureTypes = new String[creatureTypes.size()];
        if (creatureTypes != null) {
            for (int i = 0; i < creatureTypes.size(); ++i) {
                this.creatureTypes[i] = creatureTypes.get(i).getAsString();
            }
        } else {
            throw new MOQuestParseException("Missing creatures type list in Quest logic", new Object[0]);
        }
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$maxKillCount", Integer.toString(this.getMaxKillCount(questStack)));
        if (this.killWithItemStack != null) {
            info = info.replace("$itemStack", this.killWithItemStack.func_82833_r());
        }
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getKillCount(questStack) >= this.getMaxKillCount(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objetive, int objectiveIndex) {
        objetive = objetive.replace("$maxKillCount", Integer.toString(this.getMaxKillCount(questStack)));
        objetive = objetive.replace("$killCount", Integer.toString(this.getKillCount(questStack)));
        if (this.killWithItemStack != null) {
            objetive = objetive.replace("$itemStack", this.killWithItemStack.func_82833_r());
        }
        return objetive;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("MaxKillCount", this.random(random, this.minKillCount, this.maxKillCount));
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        LivingDeathEvent deathEvent;
        if (event instanceof LivingDeathEvent && (deathEvent = (LivingDeathEvent)event).getEntityLiving() != null && this.isTarget(questStack, (Entity)deathEvent.getEntityLiving())) {
            if (this.regex != null && !this.isTargetNameValid(((LivingDeathEvent)event).getEntity())) {
                return null;
            }
            if (this.shootOnly && !((LivingDeathEvent)event).getSource().func_76352_a()) {
                return null;
            }
            if (this.burnOnly && !((LivingDeathEvent)event).getSource().func_76347_k()) {
                return null;
            }
            if (this.explosionOnly && !((LivingDeathEvent)event).getSource().func_94541_c()) {
                return null;
            }
            if (this.killWithItem != null && (entityPlayer.func_184614_ca() == null || entityPlayer.func_184614_ca().func_77973_b() != this.killWithItem)) {
                return null;
            }
            if (!(this.killWithItemStack == null || entityPlayer.func_184614_ca() != null && ItemStack.func_77989_b((ItemStack)entityPlayer.func_184614_ca(), (ItemStack)this.killWithItemStack))) {
                return null;
            }
            if (this.onlyChildren && !((LivingDeathEvent)event).getEntityLiving().func_70631_g_()) {
                return null;
            }
            this.initTag(questStack);
            int currentKillCount = this.getKillCount(questStack);
            if (currentKillCount < this.getMaxKillCount(questStack)) {
                this.setKillCount(questStack, ++currentKillCount);
                if (this.isObjectiveCompleted(questStack, entityPlayer, 0) && this.autoComplete) {
                    OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)entityPlayer);
                    if (extendedProperties != null) {
                        this.markComplete(questStack, entityPlayer);
                        return new QuestLogicState(QuestState.Type.COMPLETE, true);
                    }
                    return new QuestLogicState(QuestState.Type.UPDATE, true);
                }
            }
        }
        return null;
    }

    public boolean isTarget(QuestStack questStack, Entity entity) {
        EntityRegistry.EntityRegistration registration = EntityRegistry.instance().lookupModSpawn(entity.getClass(), true);
        if (registration != null) {
            for (String type : this.creatureTypes) {
                if (!registration.getEntityName().equalsIgnoreCase(type)) continue;
                return true;
            }
        } else {
            String entityName = EntityList.func_75621_b((Entity)entity);
            for (String type : this.creatureTypes) {
                if (entityName == null || !entityName.equalsIgnoreCase(type)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTargetNameValid(Entity entity) {
        return entity.func_70005_c_().matches(this.regex);
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    public int getMaxKillCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MaxKillCount");
        }
        return 0;
    }

    public int getKillCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("KillCount");
        }
        return 0;
    }

    public void setKillCount(QuestStack questStack, int killCount) {
        this.initTag(questStack);
        this.getTag(questStack).func_74768_a("KillCount", killCount);
    }

    public String[] getCreatureTypes() {
        return this.creatureTypes;
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.xpPerKill * this.getMaxKillCount(questStack);
    }

    public QuestLogicKillCreature setOnlyChildren(boolean onlyChildren) {
        this.onlyChildren = onlyChildren;
        return this;
    }

    public QuestLogicKillCreature setShootOnly(boolean shootOnly) {
        this.shootOnly = shootOnly;
        return this;
    }

    public QuestLogicKillCreature setBurnOnly(boolean burnOnly) {
        this.burnOnly = burnOnly;
        return this;
    }

    public QuestLogicKillCreature setExplosionOnly(boolean explosionOnly) {
        this.explosionOnly = explosionOnly;
        return this;
    }

    public void setNameRegex(String regex) {
        this.regex = regex;
    }
}

