/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.network.packet.client.quest.PacketUpdateQuest;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class PlayerQuestData {
    final List<QuestStack> activeQuests = new ArrayList<QuestStack>();
    final List<QuestStack> completedQuests = new ArrayList<QuestStack>();
    final OverdriveExtendedProperties extendedProperties;

    public PlayerQuestData(OverdriveExtendedProperties extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    public void writeToNBT(NBTTagCompound tagCompound, EnumSet<DataType> dataTypes) {
        NBTTagCompound questStackNBT;
        NBTTagList activeQuestsTagList;
        if (dataTypes.contains((Object)DataType.COMPLETED_QUESTS) && this.completedQuests.size() > 0) {
            activeQuestsTagList = new NBTTagList();
            for (QuestStack questStack : this.completedQuests) {
                questStackNBT = new NBTTagCompound();
                questStack.writeToNBT(questStackNBT);
                activeQuestsTagList.func_74742_a((NBTBase)questStackNBT);
            }
            tagCompound.func_74782_a("CompletedQuests", (NBTBase)activeQuestsTagList);
        }
        if (dataTypes.contains((Object)DataType.ACTIVE_QUESTS) && this.activeQuests.size() > 0) {
            activeQuestsTagList = new NBTTagList();
            for (QuestStack questStack : this.activeQuests) {
                questStackNBT = new NBTTagCompound();
                questStack.writeToNBT(questStackNBT);
                activeQuestsTagList.func_74742_a((NBTBase)questStackNBT);
            }
            tagCompound.func_74782_a("ActiveQuests", (NBTBase)activeQuestsTagList);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound, EnumSet<DataType> dataTypes) {
        int i;
        NBTTagList activeQuestsTagList;
        if (dataTypes.contains((Object)DataType.COMPLETED_QUESTS)) {
            this.completedQuests.clear();
            try {
                if (tagCompound.func_150297_b("CompletedQuests", 9)) {
                    activeQuestsTagList = tagCompound.func_150295_c("CompletedQuests", 10);
                    for (i = 0; i < activeQuestsTagList.func_74745_c(); ++i) {
                        this.completedQuests.add(QuestStack.loadFromNBT(activeQuestsTagList.func_150305_b(i)));
                    }
                }
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading Completed Quests", new Object[0]);
            }
        }
        if (dataTypes.contains((Object)DataType.ACTIVE_QUESTS)) {
            this.activeQuests.clear();
            try {
                if (tagCompound.func_150297_b("ActiveQuests", 9)) {
                    activeQuestsTagList = tagCompound.func_150295_c("ActiveQuests", 10);
                    for (i = 0; i < activeQuestsTagList.func_74745_c(); ++i) {
                        this.activeQuests.add(QuestStack.loadFromNBT(activeQuestsTagList.func_150305_b(i)));
                    }
                }
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading Active Quests", new Object[0]);
            }
        }
    }

    public void manageQuestCompletion() {
        int i = 0;
        while (i < this.activeQuests.size()) {
            if (this.activeQuests.get(i).isCompleted()) {
                QuestStack questStack = this.activeQuests.remove(i);
                this.extendedProperties.onQuestCompleted(questStack, i);
                continue;
            }
            ++i;
        }
    }

    public boolean hasCompletedQuest(QuestStack quest) {
        for (QuestStack q : this.completedQuests) {
            if (!q.getQuest().areQuestStacksEqual(q, quest)) continue;
            return true;
        }
        return false;
    }

    public boolean hasQuest(QuestStack questStack) {
        for (QuestStack q : this.activeQuests) {
            if (!q.getQuest().areQuestStacksEqual(q, questStack)) continue;
            return true;
        }
        return false;
    }

    public QuestStack addQuest(QuestStack questStack) {
        if (questStack.getQuest() != null && this.activeQuests.add(questStack)) {
            return questStack;
        }
        return null;
    }

    public void addQuestToCompleted(QuestStack questStack) {
        if (questStack.getQuest() != null && !this.completedQuests.contains(questStack)) {
            this.completedQuests.add(questStack);
        }
    }

    public void onEvent(Event event) {
        if (this.extendedProperties != null && this.extendedProperties.getPlayer() != null) {
            for (int i = 0; i < this.activeQuests.size(); ++i) {
                QuestState questState;
                if (this.activeQuests.get(i).getQuest() == null || (questState = this.activeQuests.get(i).getQuest().onEvent(this.activeQuests.get(i), event, this.extendedProperties.getPlayer())) == null || !(this.extendedProperties.getPlayer() instanceof EntityPlayerMP)) continue;
                MatterOverdrive.NETWORK.sendTo(new PacketUpdateQuest(i, questState, this, 0), (EntityPlayerMP)this.extendedProperties.getPlayer());
            }
        }
    }

    public void clearActiveQuests() {
        this.activeQuests.clear();
    }

    public void clearCompletedQuests() {
        this.completedQuests.clear();
    }

    public void removeQuest(QuestStack questStack) {
        this.activeQuests.remove(questStack);
    }

    public QuestStack removeQuest(int id) {
        return this.activeQuests.remove(id);
    }

    public List<QuestStack> getActiveQuests() {
        return this.activeQuests;
    }

    public List<QuestStack> getCompletedQuests() {
        return this.completedQuests;
    }

    public static enum DataType {
        ACTIVE_QUESTS,
        COMPLETED_QUESTS;

    }
}

