/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.HashSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.network.packet.server.PacketTeleportPlayer;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BioticStatTeleport
extends AbstractBioticStat
implements IConfigSubscriber {
    public static final int TELEPORT_DELAY = 40;
    public static int ENERGY_PER_TELEPORT = 4096;
    private static int MAX_TELEPORT_HEIGHT_CHECK = 8;
    private static int MAX_TELEPORT_DISTANCE = 32;
    private final HashSet<String> blackListedBlocks;
    @SideOnly(value=Side.CLIENT)
    private boolean hasPressedKey;

    public BioticStatTeleport(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.setShowOnWheel(true);
        this.blackListedBlocks = new HashSet();
    }

    @Override
    public String getDetails(int level) {
        String keyName = TextFormatting.AQUA + GameSettings.func_74298_c((int)ClientProxy.keyHandler.getBinding(1).func_151463_i()) + TextFormatting.GRAY;
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), keyName, TextFormatting.YELLOW.toString() + ENERGY_PER_TELEPORT + " FE" + TextFormatting.GRAY);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (android.getPlayer().field_70170_p.field_72995_K) {
            this.manageActivate(android);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageActivate(AndroidPlayer androidPlayer) {
        if (ClientProxy.keyHandler.getBinding(1).func_151470_d() && this.equals(androidPlayer.getActiveStat())) {
            this.hasPressedKey = true;
        } else if (this.hasPressedKey) {
            Vec3d pos = this.getPos(androidPlayer);
            if (pos != null && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, androidPlayer.getUnlockedLevel(this), androidPlayer))) {
                MatterOverdrive.NETWORK.sendToServer(new PacketTeleportPlayer(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
                this.hasPressedKey = false;
            }
            this.hasPressedKey = false;
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    public Vec3d getPos(AndroidPlayer androidPlayer) {
        RayTraceResult position = MOPhysicsHelper.rayTraceForBlocks((EntityLivingBase)androidPlayer.getPlayer(), androidPlayer.getPlayer().field_70170_p, MAX_TELEPORT_DISTANCE, 0.0f, new Vec3d(0.0, (double)androidPlayer.getPlayer().func_70047_e(), 0.0), true, true);
        if (position != null && position.field_72313_a != RayTraceResult.Type.MISS && position.func_178782_a() != null) {
            BlockPos pos = this.getTopSafeBlock(androidPlayer.getPlayer().field_70170_p, position.func_178782_a(), position.field_178784_b);
            if (pos != null) {
                return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            return null;
        }
        position = MOPhysicsHelper.rayTrace((EntityLivingBase)androidPlayer.getPlayer(), androidPlayer.getPlayer().field_70170_p, 6.0, 0.0f, new Vec3d(0.0, (double)androidPlayer.getPlayer().func_70047_e(), 0.0), true, true);
        if (position != null) {
            return position.field_72307_f;
        }
        return null;
    }

    private BlockPos getTopSafeBlock(World world, BlockPos pos, EnumFacing side) {
        int airBlockCount = 0;
        int heightCheck = MAX_TELEPORT_HEIGHT_CHECK;
        if (side == EnumFacing.UP) {
            heightCheck = 3;
        }
        int height = Math.min(pos.func_177956_o() + heightCheck, world.func_72940_L());
        for (int i = pos.func_177956_o(); i < height; ++i) {
            BlockPos blockPos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            IBlockState block = world.func_180495_p(blockPos);
            String unlocalizedName = block.func_177230_c().func_149739_a().substring(5);
            if (this.blackListedBlocks.contains(unlocalizedName)) {
                return null;
            }
            airBlockCount = block.func_177230_c().isAir(block, (IBlockAccess)world, blockPos) || block.func_177230_c().func_176205_b((IBlockAccess)world, blockPos) || !block.func_177230_c().func_149703_v() || block instanceof IFluidBlock ? ++airBlockCount : 0;
            if (airBlockCount < 2) continue;
            return blockPos.func_177972_a(EnumFacing.DOWN);
        }
        pos = pos.func_177972_a(side);
        IBlockState above = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
        IBlockState aboveTwo = world.func_180495_p(pos.func_177967_a(EnumFacing.UP, 2));
        if (!above.func_177230_c().isNormalCube(above, (IBlockAccess)world, pos.func_177972_a(EnumFacing.UP)) && !aboveTwo.func_177230_c().isNormalCube(aboveTwo, (IBlockAccess)world, pos.func_177967_a(EnumFacing.UP, 2))) {
            return pos;
        }
        return null;
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (androidPlayer.getPlayer().field_70170_p.field_72995_K && !this.isEnabled(androidPlayer, level)) {
            this.hasPressedKey = false;
        }
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        long lastTeleport = android.getAndroidEffects().getEffectLong(6);
        long worldTime = android.getPlayer().field_70170_p.func_82737_E();
        return super.isEnabled(android, level) && lastTeleport <= worldTime && android.hasEnoughEnergyScaled(ENERGY_PER_TELEPORT) && this.equals(android.getActiveStat());
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getHasPressedKey() {
        return this.hasPressedKey;
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.equals(android.getActiveStat());
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.blackListedBlocks.clear();
        String[] blackListedBlocks = config.config.getStringList("teleport_blacklist", "abilities", new String[]{"hellsand", "barrier", "bedrock"}, "The Unlocalized names of the blacklist blocks that the player can't teleport to");
        Collections.addAll(this.blackListedBlocks, blackListedBlocks);
        MAX_TELEPORT_HEIGHT_CHECK = config.getInt("teleport_max_height_check", "abilities", 8, "The max height amount that the teleport ability checks if there is no 2 blocks air space");
        ENERGY_PER_TELEPORT = config.getInt("teleport_energy_cost", "abilities", 4096, "The Energy cost of each Teleportation");
        MAX_TELEPORT_DISTANCE = config.getInt("teleport_max_distance", "abilities", 32, "The maximum distance in blocks, the player can teleport to");
    }
}

