/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import matteroverdrive.data.MOAttributeModifier;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BiostatNanobots
extends AbstractBioticStat
implements IConfigSubscriber {
    private static final float REGEN_AMOUNT_PER_TICK = 0.05f;
    private static int ENERGY_PER_REGEN = 32;
    private final UUID modifierID = UUID.fromString("4548003d-1566-49aa-9378-8be2f9a064ab");

    public BiostatNanobots(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.setMaxLevel(4);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (android.getPlayer().field_70170_p.func_72820_D() % 20L == 0L && android.getPlayer().func_110143_aJ() > 0.0f && !android.getPlayer().field_70128_L && android.getPlayer().func_110143_aJ() < android.getPlayer().func_110138_aP() && android.hasEnoughEnergyScaled(ENERGY_PER_REGEN)) {
            android.getPlayer().func_70691_i(1.0f);
            android.extractEnergyScaled(ENERGY_PER_REGEN * 20);
        }
    }

    @Override
    public String getDetails(int level) {
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), TextFormatting.GREEN.toString() + 1.0f, TextFormatting.GREEN.toString() + "+" + this.getHealthBoost(level));
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new MOAttributeModifier(this.modifierID, "Android Health", this.getHealthBoost(level), 0).func_111168_a(false));
        return multimap;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.getEnergyStored() > 0;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return this.isEnabled(androidPlayer, level) && androidPlayer.getPlayer().func_110143_aJ() < androidPlayer.getPlayer().func_110138_aP();
    }

    public int getHealthBoost(int level) {
        return level * 5;
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_REGEN = config.getInt("heal_energy_per_regen", "abilities", 32, "The energy cost of each heal by the Nanobots ability");
    }
}

