/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.weapons.modules;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.weapons.WeaponRenderHandler;
import matteroverdrive.client.render.weapons.modules.ModuleRenderAbstract;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;

public class ModuleSniperScopeRender
extends ModuleRenderAbstract {
    private ResourceLocation scopeModelLocation = new ResourceLocation("matteroverdrive:models/item/sniper_scope.obj");
    private OBJModel scopeModel;
    private IBakedModel scopeBakedModelBase;
    private IBakedModel scopeBakedModelWindow;

    public ModuleSniperScopeRender(WeaponRenderHandler weaponRenderer) {
        super(weaponRenderer);
    }

    @Override
    public void renderModule(WeaponMetadataSection weaponMeta, ItemStack weaponStack, ItemStack moduleStack, float ticks) {
        Vec3d scopePos = weaponMeta.getModulePosition("default_scope");
        if (scopePos != null) {
            GlStateManager.func_179137_b((double)scopePos.field_72450_a, (double)scopePos.field_72448_b, (double)scopePos.field_72449_c);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)1);
            this.weaponRenderer.renderModel(this.scopeBakedModelWindow, weaponStack);
            GlStateManager.func_179084_k();
            this.weaponRenderer.renderModel(this.scopeBakedModelBase, weaponStack);
        }
    }

    @Override
    public void transformWeapon(WeaponMetadataSection weaponMeta, ItemStack weaponStack, ItemStack moduleStack, float ticks, float zoomValue) {
        Vec3d scopePos = weaponMeta.getModulePosition("default_scope");
        if (scopePos != null) {
            GlStateManager.func_179137_b((double)MOMathHelper.Lerp(0.0, -5.0E-4, (double)zoomValue), (double)MOMathHelper.Lerp(0.0, -scopePos.field_72448_b / 5.5, (double)zoomValue), (double)0.0);
        }
    }

    @Override
    public void onModelBake(TextureMap textureMap, RenderHandler renderHandler) {
        if (this.scopeModel == null) {
            this.scopeModel = renderHandler.getObjModel(this.scopeModelLocation, (ImmutableMap<String, String>)new ImmutableMap.Builder().put((Object)"flip-v", (Object)"true").put((Object)"ambient", (Object)"false").build());
        }
        ArrayList<String> visibleGroups = new ArrayList<String>();
        visibleGroups.add("sniper_scope");
        this.scopeBakedModelBase = this.scopeModel.bake((IModelState)new OBJModel.OBJState(visibleGroups, true), DefaultVertexFormats.field_176599_b, RenderHandler.modelTextureBakeFunc);
        visibleGroups.clear();
        visibleGroups.add("sniper_scope_window");
        this.scopeBakedModelWindow = this.scopeModel.bake((IModelState)new OBJModel.OBJState(visibleGroups, true), DefaultVertexFormats.field_176599_b, RenderHandler.modelTextureBakeFunc);
    }

    @Override
    public void onTextureStich(TextureMap textureMap, RenderHandler renderHandler) {
        if (this.scopeModel == null) {
            this.scopeModel = renderHandler.getObjModel(this.scopeModelLocation, (ImmutableMap<String, String>)new ImmutableMap.Builder().put((Object)"flip-v", (Object)"true").put((Object)"ambient", (Object)"false").build());
        }
        renderHandler.registerModelTextures(textureMap, this.scopeModel);
    }
}

