/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StarMapRendererQuadrant
extends StarMapRendererStars {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        if (spaceBody instanceof Quadrant) {
            GL11.glLineWidth((float)1.0f);
            GlStateManager.func_179132_a((boolean)false);
            Quadrant quadrant = (Quadrant)spaceBody;
            double distanceMultiply = 5.0;
            double x = (double)(-quadrant.getX() - quadrant.getSize() / 2.0f) * distanceMultiply;
            double y = (double)(-quadrant.getY()) * distanceMultiply;
            double z = (double)(-quadrant.getZ() - quadrant.getSize() / 2.0f) * distanceMultiply;
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            this.renderStars(quadrant, starMap, distanceMultiply, distanceMultiply);
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        GlStateManager.func_179141_d();
        Star star = galaxy.getStar(starMap.getDestination());
        Star origin = galaxy.getStar(starMap.getGalaxyPosition());
        if (star != null) {
            int planetCount = star.getPlanets().size();
            Color color = Reference.COLOR_HOLO;
            if (planetCount <= 0) {
                color = Reference.COLOR_HOLO_RED;
            }
            RenderUtils.applyColorWithMultipy(color, opacity);
            ClientProxy.holoIcons.renderIcon("page_icon_planet", 8.0, -28.0);
            RenderUtils.drawString(String.format("x%s", planetCount), 28, -21, color, opacity);
            DecimalFormat format = new DecimalFormat("#");
            if (GalaxyClient.getInstance().canSeeStarInfo(star, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                RenderUtils.drawString(star.getSpaceBodyName(), 0, -52, Reference.COLOR_HOLO, opacity);
            } else {
                RenderUtils.drawString(Minecraft.func_71410_x().field_71464_q, star.getSpaceBodyName(), 0, -52, Reference.COLOR_HOLO, opacity);
            }
            ClientProxy.holoIcons.renderIcon("icon_size", 48.0, -28.0);
            RenderUtils.drawString(DecimalFormat.getPercentInstance().format(star.getSize()), 68, -23, Reference.COLOR_HOLO, opacity);
            if (origin != null) {
                RenderUtils.drawString(String.format("Distance: %s LY", format.format(origin.getPosition().func_72438_d(star.getPosition()) * 8000.0)), 0, -42, Reference.COLOR_HOLO, opacity);
            }
        }
        GlStateManager.func_179118_c();
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return true;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 0.3;
    }
}

