/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks.includes;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.api.wrench.IDismantleable;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MachineHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class MOBlockMachine<TE extends TileEntity>
extends MOBlockContainer<TE>
implements IDismantleable,
IConfigSubscriber {
    public float volume = 1.0f;
    public boolean hasGui;

    public MOBlockMachine(Material material, String name) {
        super(material, name);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return super.func_180661_e();
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        IMOTileEntity entity = (IMOTileEntity)worldIn.func_175625_s(pos);
        if (entity != null) {
            try {
                entity.readFromPlaceItem(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                MOLog.log(Level.ERROR, "Could not load settings from placing item", e);
            }
            entity.onPlaced(worldIn, placer);
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        Inventory inventory = this.getInventory(worldIn, pos);
        if (inventory != null) {
            MatterHelper.DropInventory(worldIn, inventory, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return MachineHelper.canOpenMachine(worldIn, pos, playerIn, this.hasGui, this.getUnlocalizedMessage(0));
    }

    protected String getUnlocalizedMessage(int type) {
        switch (type) {
            case 0: {
                return "alert.no_rights";
            }
        }
        return "alert.no_access_default";
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (MachineHelper.canRemoveMachine(world, player, pos, willHarvest)) {
            return world.func_175698_g(pos);
        }
        return false;
    }

    public ItemStack getNBTDrop(World world, BlockPos blockPos, IMOTileEntity te) {
        IBlockState state = world.func_180495_p(blockPos);
        ItemStack itemStack = new ItemStack((Block)this, 1, this.func_180651_a(state));
        if (te != null) {
            te.writeToDropItem(itemStack);
        }
        return itemStack;
    }

    public boolean hasGui() {
        return this.hasGui;
    }

    public void setHasGui(boolean hasGui) {
        this.hasGui = hasGui;
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, BlockPos pos, boolean returnDrops) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack blockItem = this.getNBTDrop(world, pos, (IMOTileEntity)world.func_175625_s(pos));
        Inventory inventory = this.getInventory(world, pos);
        items.add(blockItem);
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                Slot slot = inventory.getSlot(i1);
                ItemStack itemstack = slot.getItem();
                if (itemstack.func_190926_b() || !slot.keepOnDismantle()) continue;
                slot.setItem(ItemStack.field_190927_a);
            }
        }
        IBlockState blockState = world.func_180495_p(pos);
        boolean flag = blockState.func_177230_c().removedByPlayer(blockState, world, pos, player, true);
        super.func_180663_b(world, pos, blockState);
        if (flag) {
            blockState.func_177230_c().func_176206_d(world, pos, blockState);
        }
        if (!returnDrops) {
            this.func_176226_b(world, pos, blockState, 0);
        } else {
            MOInventoryHelper.insertItemStackIntoInventory((IInventory)player.field_71071_by, blockItem, EnumFacing.DOWN);
        }
        return items;
    }

    protected Inventory getInventory(World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof MOTileEntityMachine) {
            MOTileEntityMachine machine = (MOTileEntityMachine)world.func_175625_s(pos);
            return machine.getInventoryContainer();
        }
        return null;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MOTileEntityMachine) {
            if (player.field_71075_bZ.field_75098_d || !((MOTileEntityMachine)tileEntity).hasOwner()) {
                return true;
            }
            if (((MOTileEntityMachine)tileEntity).getOwner().equals(player.func_146103_bH().getId())) {
                return true;
            }
            if (world.field_72995_K) {
                TextComponentString message = new TextComponentString(TextFormatting.GOLD + "[Matter Overdrive] " + TextFormatting.RED + MOStringHelper.translateToLocal("alert.no_rights.dismantle", new Object[0]).replace("$0", this.func_149732_F()));
                message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
                player.func_145747_a((ITextComponent)message);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        config.initMachineCategory(this.func_149739_a());
        this.volume = (float)config.getMachineDouble(this.func_149739_a(), "volume", 1.0, "The volume of the Machine");
    }
}

