/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.quest;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.player.EntityPlayer;

public abstract class Quest
implements IQuest {
    protected String title;
    protected int xpReward;
    protected List<IQuestReward> questRewards;

    public Quest(String title, JsonObject jsonObject) {
        this.title = title;
        this.xpReward = MOJsonHelper.getInt(jsonObject, "xp", 0);
        this.questRewards = new ArrayList<IQuestReward>();
    }

    public Quest(String title, int xpReward) {
        this.title = title;
        this.xpReward = xpReward;
        this.questRewards = new ArrayList<IQuestReward>();
    }

    public static IQuest getQuestFromName(String name) {
        return MatterOverdrive.QUESTS.getQuestByName(name);
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public String getTitle(QuestStack questStack) {
        return this.title;
    }

    @Override
    public String getTitle(QuestStack questStack, EntityPlayer entityPlayer) {
        return this.getTitle(questStack);
    }

    public Quest addQuestRewards(IQuestReward ... questRewards) {
        Collections.addAll(this.questRewards, questRewards);
        return this;
    }

    public Quest addQuestRewards(List<IQuestReward> rewards) {
        this.questRewards.addAll(rewards);
        return this;
    }

    @Override
    public void setCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
        questStack.completed = true;
    }
}

