/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.util;

import java.nio.DoubleBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public final class GLClippingPlanes {
    private static final int STACK_DEPTH = 1;
    private static final int STACK_FRAME_SIZE = 128;
    private static DoubleBuffer doubleBuffer = BufferUtils.createByteBuffer((int)128).asDoubleBuffer();
    private static int clippingPlaneFlags = 0;
    private static int totalClippingPlanes = GL11.glGetInteger((int)3378);

    private GLClippingPlanes() {
    }

    public static int glGetTotalClippingPlanes() {
        return totalClippingPlanes;
    }

    public static void glEnableClipping(int left, int right, int top, int bottom) {
        clippingPlaneFlags = 0;
        GLClippingPlanes.glEnableClipping(12288, left, -1);
        GLClippingPlanes.glEnableClipping(12289, right, 1);
        GLClippingPlanes.glEnableClipping(12290, top, -1);
        GLClippingPlanes.glEnableClipping(12291, bottom, 1);
    }

    public static void glEnableClipping(Rectangle rect) {
        clippingPlaneFlags = 0;
        GLClippingPlanes.glEnableClipping(12288, rect.getX(), -1);
        GLClippingPlanes.glEnableClipping(12289, rect.getX() + rect.getWidth(), 1);
        GLClippingPlanes.glEnableClipping(12290, rect.getY(), -1);
        GLClippingPlanes.glEnableClipping(12291, rect.getY() + rect.getHeight(), 1);
    }

    public static void glEnableHorizontalClipping(int left, int right) {
        GLClippingPlanes.glEnableClipping(12288, left, -1);
        GLClippingPlanes.glEnableClipping(12289, right, 1);
    }

    public static void glEnableVerticalClipping(int top, int bottom) {
        GLClippingPlanes.glEnableClipping(12290, top, -1);
        GLClippingPlanes.glEnableClipping(12291, bottom, 1);
    }

    public static void glEnableClipping(int plane, int value) {
        if (plane < 12288 || plane >= 12288 + totalClippingPlanes) {
            throw new IllegalArgumentException("Invalid clipping plane enum specified GL_CLIP_PLANE" + (plane - 12288));
        }
        GLClippingPlanes.glEnableClipping(plane, value, plane % 2 == 0 ? -1 : 1);
    }

    public static void glEnableClipping(Plane plane, int value) {
        GLClippingPlanes.glEnableClipping(plane.plane, value, plane.sign);
    }

    private static void glEnableClipping(int plane, int value, int sign) {
        if (value == -1) {
            return;
        }
        int offset = plane - 12288 << 2;
        doubleBuffer.put(offset + 3, value * sign).position(offset);
        clippingPlaneFlags |= plane;
        GL11.glClipPlane((int)plane, (DoubleBuffer)doubleBuffer);
        GL11.glEnable((int)plane);
    }

    public static void glEnableClipping() {
        if ((clippingPlaneFlags & 0x3000) == 12288) {
            GL11.glEnable((int)12288);
        }
        if ((clippingPlaneFlags & 0x3001) == 12289) {
            GL11.glEnable((int)12289);
        }
        if ((clippingPlaneFlags & 0x3002) == 12290) {
            GL11.glEnable((int)12290);
        }
        if ((clippingPlaneFlags & 0x3003) == 12291) {
            GL11.glEnable((int)12291);
        }
    }

    public static void glDisableClipping() {
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12288);
    }

    static {
        for (int f = 0; f < 1; ++f) {
            doubleBuffer.put(1.0).put(0.0).put(0.0).put(0.0);
            doubleBuffer.put(-1.0).put(0.0).put(0.0).put(0.0);
            doubleBuffer.put(0.0).put(1.0).put(0.0).put(0.0);
            doubleBuffer.put(0.0).put(-1.0).put(0.0).put(0.0);
        }
    }

    public static enum Plane {
        LEFT(12288),
        RIGHT(12289),
        TOP(12290),
        BOTTOM(12291);

        final int plane;
        final int sign;

        private Plane(int plane) {
            this.plane = plane;
            this.sign = plane % 2 == 0 ? -1 : 1;
        }
    }
}

