/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.gui.GuiModInfoPanel;
import com.mumfrey.liteloader.client.gui.GuiModListPanel;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import java.util.List;
import java.util.Set;

public class ModListEntry {
    private final LiteLoaderMods mods;
    private final ModInfo<?> modInfo;
    private final GuiModListPanel listPanel;
    private final GuiModInfoPanel infoPanel;
    private boolean isActive;
    private boolean isMissingDependencies;
    private boolean isMissingAPIs;
    private boolean isErrored;
    private Set<String> missingDependencies;
    private Set<String> missingAPIs;
    private boolean canBeToggled;
    private boolean willBeEnabled;
    private boolean isExternal;

    ModListEntry(LiteLoaderMods mods, LoaderEnvironment environment, bbu fontRenderer, int brandColour, List<ModInfoDecorator> decorators, ModInfo<?> modInfo) {
        this.mods = mods;
        this.modInfo = modInfo;
        this.isActive = modInfo.isActive();
        this.canBeToggled = modInfo.isToggleable() && mods.getEnabledModsList().saveAllowed();
        this.willBeEnabled = mods.isModEnabled(this.modInfo.getIdentifier());
        this.isExternal = modInfo.getContainer().isExternalJar();
        boolean bl2 = this.isErrored = modInfo.getStartupErrors() != null && modInfo.getStartupErrors().size() > 0;
        if (!modInfo.isActive()) {
            this.isActive = modInfo.getContainer().isEnabled(environment);
            Object modContainer = modInfo.getContainer();
            if (modContainer instanceof LoadableMod) {
                LoadableMod loadableMod = (LoadableMod)modContainer;
                this.missingDependencies = loadableMod.getMissingDependencies();
                this.missingAPIs = loadableMod.getMissingAPIs();
                this.isMissingDependencies = this.missingDependencies.size() > 0;
                this.isMissingAPIs = this.missingAPIs.size() > 0;
            }
        }
        this.infoPanel = new GuiModInfoPanel(this, fontRenderer, brandColour, modInfo);
        this.listPanel = new GuiModListPanel(this, fontRenderer, brandColour, modInfo, decorators);
    }

    protected String getTitleText() {
        return this.modInfo.getDisplayName();
    }

    protected String getVersionText() {
        return brp.a((String)"gui.about.versiontext", (Object[])new Object[]{this.modInfo.getVersion()});
    }

    protected String getStatusText() {
        String statusText;
        String string = statusText = this.isExternal ? brp.a((String)"gui.status.loaded", (Object[])new Object[0]) : brp.a((String)"gui.status.active", (Object[])new Object[0]);
        if (this.isMissingAPIs) {
            statusText = "\u00a75" + brp.a((String)"gui.status.missingapis", (Object[])new Object[0]);
            if (this.canBeToggled && !this.willBeEnabled) {
                statusText = "\u00a7c" + brp.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        } else if (this.isMissingDependencies) {
            statusText = "\u00a7e" + brp.a((String)"gui.status.missingdeps", (Object[])new Object[0]);
            if (this.canBeToggled && !this.willBeEnabled) {
                statusText = "\u00a7c" + brp.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        } else if (this.isErrored) {
            statusText = "\u00a7c" + brp.a((String)"gui.status.startuperror", (Object[])new Object[0]);
        } else if (this.canBeToggled) {
            if (!this.isActive && !this.willBeEnabled) {
                statusText = "\u00a77" + brp.a((String)"gui.status.disabled", (Object[])new Object[0]);
            }
            if (!this.isActive && this.willBeEnabled) {
                statusText = "\u00a7a" + brp.a((String)"gui.status.pending.enabled", (Object[])new Object[0]);
            }
            if (this.isActive && !this.willBeEnabled) {
                statusText = "\u00a7c" + brp.a((String)"gui.status.pending.disabled", (Object[])new Object[0]);
            }
        }
        return statusText;
    }

    public void toggleEnabled() {
        if (this.canBeToggled) {
            this.willBeEnabled = !this.willBeEnabled;
            this.mods.setModEnabled(this.modInfo.getIdentifier(), this.willBeEnabled);
        }
    }

    public String getKey() {
        return (this.isErrored ? "0000" : "") + this.modInfo.getIdentifier() + Integer.toHexString(this.hashCode());
    }

    public LiteMod getModInstance() {
        return this.modInfo.getMod();
    }

    public Class<? extends LiteMod> getModClass() {
        return this.modInfo.getModClass();
    }

    public String getName() {
        return this.modInfo.getDisplayName();
    }

    public String getVersion() {
        return this.modInfo.getVersion();
    }

    public String getAuthor() {
        return this.modInfo.getAuthor();
    }

    public String getDescription() {
        return this.modInfo.getDescription();
    }

    public boolean isEnabled() {
        return this.isActive;
    }

    public boolean canBeToggled() {
        return this.canBeToggled;
    }

    public boolean willBeEnabled() {
        return this.willBeEnabled;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isErrored() {
        return this.isErrored;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isMissingAPIs() {
        return this.isMissingAPIs;
    }

    public boolean isMissingDependencies() {
        return this.isMissingDependencies;
    }

    public GuiModListPanel getListPanel() {
        return this.listPanel;
    }

    public GuiModInfoPanel getInfoPanel() {
        return this.infoPanel;
    }
}

