/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiSimpleScrollBar;
import com.mumfrey.liteloader.client.gui.ModListEntry;
import com.mumfrey.liteloader.client.util.GLClippingPlanes;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.lwjgl.opengl.GL11;

public class GuiPanelMods
extends GuiPanel {
    private static final int SCROLLBAR_WIDTH = 5;
    private final GuiLiteLoaderPanel parentScreen;
    private final ConfigManager configManager;
    private List<ModListEntry> mods = new ArrayList<ModListEntry>();
    private ModListEntry selectedMod = null;
    private int doubleClickTime = 0;
    private bcb btnToggle;
    private bcb btnConfig;
    private int listHeight = 100;
    private GuiSimpleScrollBar scrollBar = new GuiSimpleScrollBar();
    private int brandColour;

    public GuiPanelMods(GuiLiteLoaderPanel parentScreen, bao minecraft, LiteLoaderMods mods, LoaderEnvironment environment, ConfigManager configManager, int brandColour, List<ModInfoDecorator> decorators) {
        super(minecraft);
        this.parentScreen = parentScreen;
        this.configManager = configManager;
        this.brandColour = brandColour;
        this.populateModList(mods, environment, decorators);
    }

    private void populateModList(LiteLoaderMods mods, LoaderEnvironment environment, List<ModInfoDecorator> decorators) {
        ModListEntry modListEntry;
        TreeMap<String, ModListEntry> sortedMods = new TreeMap<String, ModListEntry>();
        for (ModInfo<LoadableMod<?>> modInfo : mods.getLoadedMods()) {
            modListEntry = new ModListEntry(mods, environment, this.mc.l, this.brandColour, decorators, modInfo);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        for (ModInfo<LoadableMod<?>> modInfo : mods.getDisabledMods()) {
            modListEntry = new ModListEntry(mods, environment, this.mc.l, this.brandColour, decorators, modInfo);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        for (ModInfo<LoadableMod<?>> modInfo : mods.getInjectedTweaks()) {
            modListEntry = new ModListEntry(mods, environment, this.mc.l, this.brandColour, decorators, modInfo);
            sortedMods.put(modListEntry.getKey(), modListEntry);
        }
        this.mods.addAll(sortedMods.values());
        if (this.mods.size() > 0) {
            this.selectedMod = this.mods.get(0);
        }
    }

    @Override
    boolean stealFocus() {
        return false;
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        int rightPanelLeftEdge = 16 + (this.width - 12 - 12 - 4) / 2;
        this.controls.clear();
        this.btnToggle = new bcb(0, rightPanelLeftEdge, this.height - 26 - 24, 90, 20, brp.a((String)"gui.enablemod", (Object[])new Object[0]));
        this.controls.add(this.btnToggle);
        this.btnConfig = new bcb(1, rightPanelLeftEdge + 92, this.height - 26 - 24, 69, 20, brp.a((String)"gui.modsettings", (Object[])new Object[0]));
        this.controls.add(this.btnConfig);
        this.selectMod(this.selectedMod);
    }

    @Override
    void onTick() {
        if (this.doubleClickTime > 0) {
            --this.doubleClickTime;
        }
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void mousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (this.scrollBar.wasMouseOver()) {
                this.scrollBar.setDragging(true);
            }
            if (mouseY > 83 && mouseY < this.height - 26) {
                ModListEntry lastSelectedMod = this.selectedMod;
                for (ModListEntry mod : this.mods) {
                    if (!mod.getListPanel().isMouseOver()) continue;
                    this.selectMod(mod);
                    if (mod.getListPanel().isMouseOverIcon()) {
                        mod.getListPanel().iconClick((Object)this.parentScreen);
                    } else if (mod == lastSelectedMod && this.doubleClickTime > 0 && this.btnConfig.m) {
                        this.actionPerformed(this.btnConfig);
                    }
                    this.doubleClickTime = 5;
                }
                if (this.selectedMod != null && this.selectedMod == lastSelectedMod) {
                    this.selectedMod.getInfoPanel().mousePressed();
                }
            }
        }
        super.mousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.parentScreen.onToggled();
            return;
        }
        if (keyCode == 200) {
            int selectedIndex = this.mods.indexOf(this.selectedMod) - 1;
            if (selectedIndex > -1) {
                this.selectMod(this.mods.get(selectedIndex));
            }
            this.scrollSelectedModIntoView();
        } else if (keyCode == 208) {
            int selectedIndex = this.mods.indexOf(this.selectedMod);
            if (selectedIndex > -1 && selectedIndex < this.mods.size() - 1) {
                this.selectMod(this.mods.get(selectedIndex + 1));
            }
            this.scrollSelectedModIntoView();
        } else if (keyCode == 57 || keyCode == 28 || keyCode == 156 || keyCode == 205) {
            this.toggleSelectedMod();
        } else if (keyCode == 61) {
            this.parentScreen.showLogPanel();
        } else if (keyCode == 59) {
            this.parentScreen.showAboutPanel();
        }
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.scrollBar.setDragging(false);
            if (this.selectedMod != null) {
                this.selectedMod.getInfoPanel().mouseReleased();
            }
        }
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
        if (this.selectedMod == null || !this.selectedMod.getInfoPanel().mouseWheelScrolled(mouseWheelDelta)) {
            this.scrollBar.offsetValue(-mouseWheelDelta / 8);
        }
    }

    @Override
    void actionPerformed(bcb control) {
        if (control.k == 0) {
            this.toggleSelectedMod();
        }
        if (control.k == 1 && this.selectedMod != null && this.selectedMod.getModClass() != null) {
            ConfigPanel panel = this.configManager.getPanel(this.selectedMod.getModClass());
            LiteMod mod = this.selectedMod.getModInstance();
            this.parentScreen.openConfigPanel(panel, mod);
        }
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.parentScreen.drawInfoPanel(mouseX, mouseY, partialTicks, 0, 26);
        int innerWidth = this.width - 12 - 12 - 4;
        int panelWidth = innerWidth / 2;
        int panelHeight = this.height - 26 - 83;
        this.drawModsList(mouseX, mouseY, partialTicks, panelWidth, panelHeight);
        this.drawSelectedMod(mouseX, mouseY, partialTicks, panelWidth, panelHeight);
        super.draw(mouseX, mouseY, partialTicks);
    }

    private void drawModsList(int mouseX, int mouseY, float partialTicks, int width, int height) {
        this.scrollBar.drawScrollBar(mouseX, mouseY, partialTicks, 12 + width - 5, 83, 5, height, this.listHeight);
        GLClippingPlanes.glEnableClipping(12, 12 + width - 5 - 1, 83, this.height - 26);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(83 - this.scrollBar.getValue()), (float)0.0f);
        mouseY -= 83 - this.scrollBar.getValue();
        int yPos = 0;
        for (ModListEntry mod : this.mods) {
            yPos += mod.getListPanel().draw(mouseX, mouseY, partialTicks, 12, yPos, width - 6, mod == this.selectedMod);
        }
        yPos = 0;
        for (ModListEntry mod : this.mods) {
            yPos += mod.getListPanel().postRender(mouseX, mouseY, partialTicks, 12, yPos, width - 6, mod == this.selectedMod);
        }
        GL11.glPopMatrix();
        GLClippingPlanes.glDisableClipping();
        this.listHeight = yPos;
        this.scrollBar.setMaxValue(this.listHeight - height);
    }

    private void drawSelectedMod(int mouseX, int mouseY, float partialTicks, int width, int height) {
        if (this.selectedMod != null) {
            int left = 12 + width;
            int right = this.width - 12;
            int spaceForButtons = this.btnConfig.m || this.btnToggle.m ? 28 : 0;
            GLClippingPlanes.glEnableClipping(left, right, 83, this.height - 26 - spaceForButtons);
            this.selectedMod.getInfoPanel().draw(mouseX, mouseY, partialTicks, left, 83, right - left, height - spaceForButtons);
            GLClippingPlanes.glDisableClipping();
        }
    }

    private void selectMod(ModListEntry mod) {
        if (this.selectedMod != null) {
            this.selectedMod.getInfoPanel().mouseReleased();
        }
        this.selectedMod = mod;
        this.btnToggle.m = false;
        this.btnConfig.m = false;
        if (this.selectedMod != null && this.selectedMod.canBeToggled()) {
            this.btnToggle.m = true;
            this.btnToggle.j = this.selectedMod.willBeEnabled() ? brp.a((String)"gui.disablemod", (Object[])new Object[0]) : brp.a((String)"gui.enablemod", (Object[])new Object[0]);
            this.btnConfig.m = this.configManager.hasPanel(this.selectedMod.getModClass());
        }
    }

    private void toggleSelectedMod() {
        if (this.selectedMod != null) {
            this.selectedMod.toggleEnabled();
            this.selectMod(this.selectedMod);
        }
    }

    private void scrollSelectedModIntoView() {
        if (this.selectedMod == null) {
            return;
        }
        int yPos = 0;
        for (ModListEntry mod : this.mods) {
            if (mod == this.selectedMod) break;
            yPos += mod.getListPanel().getHeight();
        }
        if (yPos < this.scrollBar.getValue()) {
            this.scrollBar.setValue(yPos);
            return;
        }
        int panelHeight = this.height - 26 - 83;
        int modHeight = this.selectedMod.getListPanel().getHeight();
        if (yPos - this.scrollBar.getValue() + modHeight > panelHeight) {
            this.scrollBar.setValue(yPos - panelHeight + modHeight);
        }
    }
}

