/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.BrandingProvider;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.ModInfoDecorator;
import com.mumfrey.liteloader.client.api.LiteLoaderBrandingProvider;
import com.mumfrey.liteloader.client.gui.GuiHoverLabel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.client.gui.GuiPanelAbout;
import com.mumfrey.liteloader.client.gui.GuiPanelConfigContainer;
import com.mumfrey.liteloader.client.gui.GuiPanelError;
import com.mumfrey.liteloader.client.gui.GuiPanelLiteLoaderLog;
import com.mumfrey.liteloader.client.gui.GuiPanelMods;
import com.mumfrey.liteloader.client.gui.GuiPanelSettings;
import com.mumfrey.liteloader.client.gui.GuiPanelUpdateCheck;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiLiteLoaderPanel
extends bdw {
    static final int LEFT_EDGE = 80;
    static final int MARGIN = 12;
    static final int TAB_WIDTH = 20;
    static final int TAB_HEIGHT = 40;
    static final int TAB_TOP = 20;
    static final int PANEL_TOP = 83;
    static final int PANEL_BOTTOM = 26;
    private static final double TWEEN_RATE = 0.08;
    private static boolean displayErrorToolTip = true;
    private bdw parentScreen;
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private long tickNumber;
    private double lastTick;
    private double tweenAmount = 0.0;
    private boolean mouseDown;
    private boolean toggled;
    private boolean toggleable;
    private float tabOpacity = 0.0f;
    private boolean showTab = true;
    private String activeModText;
    private String versionText;
    private GuiPanel currentPanel;
    private final GuiPanelMods modsPanel;
    private final GuiPanelSettings settingsPanel;
    private int brandColour = -12089903;
    private bqx logoResource = LiteLoaderBrandingProvider.ABOUT_TEXTURE;
    private rf logoCoords = LiteLoaderBrandingProvider.LOGO_COORDS;
    private bqx iconResource = LiteLoaderBrandingProvider.ABOUT_TEXTURE;
    private rf iconCoords = LiteLoaderBrandingProvider.ICON_COORDS;
    private List<ModInfoDecorator> modInfoDecorators = new ArrayList<ModInfoDecorator>();
    private boolean mouseOverLogo = false;
    private int startupErrorCount = 0;
    private int criticalErrorCount = 0;
    private String notification;

    public GuiLiteLoaderPanel(bao minecraft, bdw parentScreen, LiteLoaderMods mods, LoaderEnvironment environment, LoaderProperties properties, ConfigManager configManager, boolean showTab) {
        this.k = minecraft;
        this.q = minecraft.l;
        this.parentScreen = parentScreen;
        this.showTab = showTab;
        this.environment = environment;
        this.properties = properties;
        this.toggleable = true;
        this.versionText = brp.a((String)"gui.about.versiontext", (Object[])new Object[]{LiteLoader.getVersion()});
        this.activeModText = brp.a((String)"gui.about.modsloaded", (Object[])new Object[]{mods.getLoadedMods().size()});
        this.initBranding();
        this.modsPanel = new GuiPanelMods(this, minecraft, mods, environment, configManager, this.brandColour, this.modInfoDecorators);
        this.currentPanel = this.modsPanel;
        this.settingsPanel = new GuiPanelSettings(this, minecraft);
        this.startupErrorCount = mods.getStartupErrorCount();
        this.criticalErrorCount = mods.getCriticalErrorCount();
    }

    private void initBranding() {
        Object logoProvider = null;
        int brandingColourProviderPriority = Integer.MIN_VALUE;
        int logoProviderPriority = Integer.MIN_VALUE;
        int iconProviderPriority = Integer.MIN_VALUE;
        for (LiteAPI api : LiteLoader.getAPIs()) {
            ModInfoDecorator modInfoDecorator;
            BrandingProvider brandingProvider = LiteLoader.getCustomisationProvider(api, BrandingProvider.class);
            if (brandingProvider != null) {
                if (brandingProvider.getBrandingColour() != 0 && brandingProvider.getPriority() > brandingColourProviderPriority) {
                    brandingColourProviderPriority = brandingProvider.getPriority();
                    this.brandColour = 0xFF000000 | brandingProvider.getBrandingColour();
                }
                bqx logoResource = brandingProvider.getLogoResource();
                rf logoCoords = brandingProvider.getLogoCoords();
                if (logoResource != null && logoCoords != null && brandingProvider.getPriority() > logoProviderPriority) {
                    logoProvider = api;
                    logoProviderPriority = brandingProvider.getPriority();
                    this.logoResource = logoResource;
                    this.logoCoords = logoCoords;
                }
                bqx iconResource = brandingProvider.getIconResource();
                rf iconCoords = brandingProvider.getIconCoords();
                if (iconResource != null && iconCoords != null && brandingProvider.getPriority() > iconProviderPriority) {
                    iconProviderPriority = brandingProvider.getPriority();
                    this.iconResource = iconResource;
                    this.iconCoords = iconCoords;
                }
            }
            if ((modInfoDecorator = LiteLoader.getCustomisationProvider(api, ModInfoDecorator.class)) == null) continue;
            this.modInfoDecorators.add(modInfoDecorator);
        }
        if (logoProvider != null && !LiteLoaderCoreAPI.class.isAssignableFrom(logoProvider.getClass())) {
            this.versionText = brp.a((String)"gui.about.poweredbyversion", (Object[])new Object[]{logoProvider.getVersion(), LiteLoader.getVersion()});
        }
    }

    public int getBrandColour() {
        return this.brandColour;
    }

    public void release() {
        this.parentScreen = null;
    }

    public bdw getScreen() {
        return this.parentScreen;
    }

    public boolean isOpen() {
        return this.tweenAmount > 0.0;
    }

    public void setToggleable(boolean toggleable) {
        this.toggleable = toggleable;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    public void b() {
        displayErrorToolTip = false;
        this.currentPanel.setSize(this.l - 80, this.m);
        this.n.add(new GuiHoverLabel(2, 92, this.m - 26 + 9, this.q, brp.a((String)"gui.about.taboptions", (Object[])new Object[0]), this.brandColour));
        if (LiteLoaderVersion.getUpdateSite().canCheckForUpdate() && this.k.f == null) {
            this.n.add(new GuiHoverLabel(3, 130 + this.q.a(this.versionText) + 6, 50, this.q, brp.a((String)"gui.about.checkupdates", (Object[])new Object[0]), this.brandColour));
        }
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void m() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void a(bao minecraft, int width, int height) {
        if (this.k.n == this) {
            this.parentScreen.a(minecraft, width, height);
        }
        super.a(minecraft, width, height);
    }

    public void e() {
        this.currentPanel.onTick();
        ++this.tickNumber;
        if (this.k.n == this) {
            this.k.n = this.parentScreen;
            this.parentScreen.e();
            this.k.n = this;
        }
        if (this.toggled && this.toggleable) {
            this.onToggled();
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreen(mouseX, mouseY, partialTicks, false);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks, boolean alwaysExpandTab) {
        boolean active;
        boolean bl2 = active = this.k.n == this;
        if (active) {
            GL11.glClear((int)256);
            this.parentScreen.a(-10, -10, partialTicks);
            GL11.glClear((int)256);
        } else {
            this.l = this.parentScreen.l;
            this.m = this.parentScreen.m;
        }
        float xOffset = (float)(this.l - 80) * this.calcTween(partialTicks, active) + 16.0f + this.tabOpacity * -32.0f;
        int offsetMouseX = mouseX - (int)xOffset;
        boolean mouseOverTab = this.showTab && offsetMouseX > 60 && offsetMouseX < 80 && mouseY > 20 && mouseY < 60;
        this.handleMouseClick(offsetMouseX, mouseY, partialTicks, active, mouseOverTab);
        this.tabOpacity = mouseOverTab || alwaysExpandTab || this.startupErrorCount > 0 || this.notification != null || this.isOpen() ? 0.5f : Math.max(0.0f, this.tabOpacity - partialTicks * 0.1f);
        this.drawPanel(offsetMouseX, mouseY, partialTicks, active, xOffset);
        this.drawTooltips(mouseX, mouseY, partialTicks, active, xOffset, mouseOverTab);
    }

    private void drawPanel(int mouseX, int mouseY, float partialTicks, boolean active, float xOffset) {
        this.mouseOverLogo = false;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xOffset, (float)0.0f, (float)0.0f);
        GuiLiteLoaderPanel.a((int)80, (int)0, (int)this.l, (int)this.m, (int)-1342177280);
        if (this.showTab) {
            GuiLiteLoaderPanel.a((int)80, (int)0, (int)81, (int)20, (int)-1);
            GuiLiteLoaderPanel.a((int)80, (int)60, (int)81, (int)this.m, (int)-1);
            this.k.P().a(LiteLoaderBrandingProvider.ABOUT_TEXTURE);
            GuiLiteLoaderPanel.glDrawTexturedRect(60, 20, 21, 40, 80, 80, 122, 160, 0.5f + this.tabOpacity);
            if (this.startupErrorCount > 0) {
                GuiLiteLoaderPanel.glDrawTexturedRect(67, 22, 12, 12, 134, 92, 146, 104, 0.5f + this.tabOpacity);
            } else if (this.notification != null) {
                GuiLiteLoaderPanel.glDrawTexturedRect(67, 22, 12, 12, 146, 92, 158, 104, 0.5f + this.tabOpacity);
            }
        } else {
            GuiLiteLoaderPanel.a((int)80, (int)0, (int)81, (int)this.m, (int)-1);
        }
        if (this.isOpen()) {
            if (this.currentPanel.isCloseRequested()) {
                this.closeCurrentPanel();
            }
            this.drawCurrentPanel(mouseX, mouseY, partialTicks);
            if (!this.currentPanel.stealFocus()) {
                super.a(mouseX, mouseY, partialTicks);
            }
        } else {
            this.closeCurrentPanel();
        }
        GL11.glPopMatrix();
    }

    private void drawCurrentPanel(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)80.0f, (float)0.0f, (float)0.0f);
        this.currentPanel.draw(mouseX - 80, mouseY, partialTicks);
        GL11.glPopMatrix();
    }

    protected boolean drawInfoPanel(int mouseX, int mouseY, float partialTicks, int left, int bottom) {
        int right = this.l - 12 - 80 + left;
        this.k.P().a(this.logoResource);
        GuiLiteLoaderPanel.glDrawTexturedRect(left += 12, 12, this.logoCoords, 1.0f);
        this.k.P().a(this.iconResource);
        GuiLiteLoaderPanel.glDrawTexturedRect(right - this.iconCoords.a(), 12, this.iconCoords, 1.0f);
        this.q.b(this.versionText, left + 38, 50, -1);
        this.q.b(this.activeModText, left + 38, 60, -5592406);
        GuiLiteLoaderPanel.a((int)left, (int)80, (int)right, (int)81, (int)-6710887);
        GuiLiteLoaderPanel.a((int)left, (int)(this.m - bottom + 2), (int)right, (int)(this.m - bottom + 3), (int)-6710887);
        this.mouseOverLogo = mouseY > 12 && mouseY < 12 + this.logoCoords.b() && mouseX > left && mouseX < left + this.logoCoords.a();
        return this.mouseOverLogo;
    }

    private void drawTooltips(int mouseX, int mouseY, float partialTicks, boolean active, float xOffset, boolean mouseOverTab) {
        boolean annoyingTip;
        boolean bl2 = annoyingTip = this.startupErrorCount > 0 || this.notification != null;
        if (mouseOverTab && this.tweenAmount < 0.01) {
            GuiLiteLoaderPanel.drawTooltip(this.q, LiteLoader.getVersionDisplayString(), mouseX, mouseY, this.l, this.m, 0xFFFFFF, -1342177280);
            GuiLiteLoaderPanel.drawTooltip(this.q, this.activeModText, mouseX, mouseY + 13, this.l, this.m, 0xCCCCCC, -1342177280);
            if (annoyingTip) {
                this.drawNotificationTooltip(mouseX, mouseY - 13);
            }
        } else if (displayErrorToolTip && annoyingTip && !active && this.parentScreen instanceof bee) {
            this.drawNotificationTooltip((int)xOffset + 80 - 12, 22);
        }
    }

    private void drawNotificationTooltip(int left, int top) {
        if (this.startupErrorCount > 0) {
            GuiLiteLoaderPanel.drawTooltip(this.q, brp.a((String)"gui.error.tooltip", (Object[])new Object[]{this.startupErrorCount, this.criticalErrorCount}), left, top, this.l, this.m, 0xFF5555, -1338834944);
        } else if (this.notification != null) {
            GuiLiteLoaderPanel.drawTooltip(this.q, this.notification, left, top, this.l, this.m, 0xFFFFFF, -1342177127);
        }
    }

    protected void a(bcb button) {
        if (button.k == 2) {
            this.setCurrentPanel(this.settingsPanel);
        }
        if (button.k == 3) {
            this.setCurrentPanel(new GuiPanelUpdateCheck(this, this.k, LiteLoaderVersion.getUpdateSite(), "LiteLoader", this.properties));
        }
    }

    protected void a(char keyChar, int keyCode) {
        this.currentPanel.keyPressed(keyChar, keyCode);
    }

    void showLogPanel() {
        this.setCurrentPanel(new GuiPanelLiteLoaderLog(this.k, this));
    }

    void showAboutPanel() {
        this.setCurrentPanel(new GuiPanelAbout(this.k, this));
    }

    public void showErrorPanel(ModInfo<?> mod) {
        this.setCurrentPanel(new GuiPanelError(this.k, this, mod));
    }

    protected void a(int mouseX, int mouseY, int button) {
        this.currentPanel.mousePressed(mouseX - 80, mouseY, button);
        if (button == 0 && this.mouseOverLogo && !this.currentPanel.stealFocus()) {
            this.showAboutPanel();
        }
        if (!this.currentPanel.stealFocus()) {
            super.a(mouseX, mouseY, button);
        }
    }

    protected void b(int mouseX, int mouseY, int button) {
        if (button == -1) {
            this.currentPanel.mouseMoved(mouseX - 80, mouseY);
        } else {
            this.currentPanel.mouseReleased(mouseX - 80, mouseY, button);
        }
        if (!this.currentPanel.stealFocus()) {
            super.b(mouseX, mouseY, button);
        }
    }

    public void k() {
        int mouseWheelDelta = Mouse.getEventDWheel();
        if (mouseWheelDelta != 0) {
            this.currentPanel.mouseWheelScrolled(mouseWheelDelta);
        }
        super.k();
    }

    public void handleMouseClick(int mouseX, int mouseY, float partialTicks, boolean active, boolean mouseOverTab) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if ((active && mouseX < 80 && this.tweenAmount > 0.75 || mouseOverTab) && !this.mouseDown && mouseDown) {
            this.mouseDown = true;
            this.toggled = true;
        } else if (this.mouseDown && !mouseDown) {
            this.mouseDown = false;
        }
    }

    private float calcTween(float partialTicks, boolean active) {
        double tickValue = (float)this.tickNumber + partialTicks;
        if (active && this.tweenAmount < 1.0) {
            this.tweenAmount = Math.min(1.0, this.tweenAmount + (tickValue - this.lastTick) * 0.08);
        } else if (!active && this.isOpen()) {
            this.tweenAmount = Math.max(0.0, this.tweenAmount - (tickValue - this.lastTick) * 0.08);
        }
        this.lastTick = tickValue;
        return 1.0f - (float)Math.sin(this.tweenAmount * 0.5 * Math.PI);
    }

    void onToggled() {
        this.toggled = false;
        this.k.a((bdw)(this.k.n == this ? this.parentScreen : this));
    }

    void openConfigPanel(ConfigPanel panel, LiteMod mod) {
        if (panel != null) {
            this.setCurrentPanel(new GuiPanelConfigContainer(this.k, panel, mod));
        }
    }

    private void setCurrentPanel(GuiPanel newPanel) {
        this.closeCurrentPanel();
        this.currentPanel = newPanel;
        this.currentPanel.setSize(this.l - 80, this.m);
        this.currentPanel.onShown();
    }

    private void closeCurrentPanel() {
        this.currentPanel.onHidden();
        this.currentPanel = this.modsPanel;
        this.modsPanel.setSize(this.l - 80, this.m);
    }

    protected static void drawTooltip(bbu fontRenderer, String tooltipText, int mouseX, int mouseY, int screenWidth, int screenHeight, int colour, int backgroundColour) {
        int textSize = fontRenderer.a(tooltipText);
        mouseX = Math.max(0, Math.min(screenWidth - 4, mouseX - 4));
        mouseY = Math.max(0, Math.min(screenHeight - 16, mouseY));
        GuiLiteLoaderPanel.a((int)(mouseX - textSize - 2), (int)mouseY, (int)(mouseX + 2), (int)(mouseY + 12), (int)backgroundColour);
        fontRenderer.a(tooltipText, mouseX - textSize, mouseY + 2, colour);
    }

    static void glDrawTexturedRect(int x, int y, int width, int height, int u2, int v2, int u22, int v22, float alpha) {
        float texMapScale = 0.00390625f;
        GuiLiteLoaderPanel.glDrawTexturedRect(x, y, width, height, (float)u2 * texMapScale, (float)v2 * texMapScale, (float)u22 * texMapScale, (float)v22 * texMapScale, alpha);
    }

    static void glDrawTexturedRect(int x, int y, int width, int height, float u2, float v2, float u22, float v22, float alpha) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        bmh tessellator = bmh.a;
        tessellator.b();
        tessellator.a((double)(x + 0), (double)(y + height), 0.0, (double)u2, (double)v22);
        tessellator.a((double)(x + width), (double)(y + height), 0.0, (double)u22, (double)v22);
        tessellator.a((double)(x + width), (double)(y + 0), 0.0, (double)u22, (double)v2);
        tessellator.a((double)(x + 0), (double)(y + 0), 0.0, (double)u2, (double)v2);
        tessellator.a();
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.01f);
    }

    static void glDrawTexturedRect(int x, int y, rf icon, float alpha) {
        GuiLiteLoaderPanel.glDrawTexturedRect(x, y, icon.a(), icon.b(), icon.c(), icon.e(), icon.d(), icon.f(), alpha);
    }
}

