/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.rendering;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class RenderUtils {
    private static ResourceLocation WHITE = null;
    private static ResourceLocation BLANK = null;

    public static ResourceLocation getWhiteImageResource() {
        ResourceLocation r;
        if (WHITE != null) {
            return WHITE;
        }
        if (Minecraft.m_91087_().m_91097_() == null) {
            return null;
        }
        NativeImage i = new NativeImage(1, 1, true);
        i.m_84988_(0, 0, Color.WHITE.getRGB());
        WHITE = r = Minecraft.m_91087_().m_91097_().m_118490_("whiteback", new DynamicTexture(i));
        return r;
    }

    public static ResourceLocation getBlankImageResource() {
        ResourceLocation r;
        if (BLANK != null) {
            return BLANK;
        }
        if (Minecraft.m_91087_().m_91097_() == null) {
            return null;
        }
        NativeImage i = new NativeImage(1, 1, true);
        i.m_84988_(0, 0, new Color(255, 255, 255, 0).getRGB());
        BLANK = r = Minecraft.m_91087_().m_91097_().m_118490_("blankback", new DynamicTexture(i));
        return r;
    }

    public static void setScale(PoseStack matrix, float scale) {
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
    }

    public static void postScale(PoseStack matrix) {
        matrix.m_85849_();
    }

    public static void doubleBlit(double x, double y, float f1, float f2, int w, int h) {
        RenderUtils.innerDoubleBlit(x, x + (double)w, y, y + (double)h, 0, (f1 + 0.0f) / (float)w, (f1 + (float)w) / (float)w, (f2 + 0.0f) / (float)h, (f2 + (float)h) / (float)h);
    }

    public static void innerDoubleBlit(double x, double xEnd, double y, double yEnd, int z, float f1, float f2, float f3, float f4) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(x, yEnd, (double)z).m_7421_(f1, f4).m_5752_();
        bufferbuilder.m_5483_(xEnd, yEnd, (double)z).m_7421_(f2, f4).m_5752_();
        bufferbuilder.m_5483_(xEnd, y, (double)z).m_7421_(f2, f3).m_5752_();
        bufferbuilder.m_5483_(x, y, (double)z).m_7421_(f1, f3).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static Color getColorFromHexString(String hex) {
        try {
            hex = hex.replace("#", "");
            if (hex.length() == 6) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            if (hex.length() == 8) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setZLevelPre(PoseStack matrix, int zLevel) {
        RenderSystem.m_69465_();
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.0, (double)zLevel);
    }

    public static void setZLevelPost(PoseStack matrix) {
        matrix.m_85849_();
        RenderSystem.m_69482_();
    }

    public static void bindTexture(ResourceLocation texture, boolean depthTest) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69478_();
        if (depthTest) {
            RenderSystem.m_69482_();
        }
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderUtils.bindTexture(texture, false);
    }

    public static void fill(PoseStack matrix, float minX, float minY, float maxX, float maxY, int color, float opacity) {
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        a *= opacity;
        BufferBuilder bb = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bb.m_85982_(matrix4f, minX, maxY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bb.m_85982_(matrix4f, maxX, maxY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bb.m_85982_(matrix4f, maxX, minY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bb.m_85982_(matrix4f, minX, minY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bb.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bb);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

