/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom;

import de.keksuccino.justzoom.JustZoom;
import de.keksuccino.justzoom.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZoomHandler {
    private static Minecraft mc = Minecraft.m_91087_();
    public static boolean isZoomed = false;
    public static double zoomFactor = (Double)JustZoom.config.getOrDefault("base_zoom_factor", (Object)0.25);
    private static double cachedFov;
    private static double cachedDefaultFov;
    private static boolean cachedSmoothCamera;

    public static void init() {
        KeyBindings.init();
        MinecraftForge.EVENT_BUS.register((Object)new ZoomHandler());
    }

    public static double handleZoom(double fov) {
        cachedDefaultFov = fov;
        if (KeyBindings.keyToggleZoom.m_90857_()) {
            if (!isZoomed) {
                cachedSmoothCamera = ZoomHandler.mc.f_91066_.f_92067_;
            }
            ZoomHandler.mc.f_91066_.f_92067_ = true;
            isZoomed = true;
            double modifiedZoom = fov * zoomFactor;
            if (modifiedZoom < 1.0) {
                modifiedZoom = 1.0;
            }
            if (modifiedZoom > 170.0) {
                modifiedZoom = 170.0;
            }
            cachedFov = modifiedZoom;
            return modifiedZoom;
        }
        if (isZoomed) {
            ZoomHandler.mc.f_91066_.f_92067_ = cachedSmoothCamera;
            isZoomed = false;
            if (((Boolean)JustZoom.config.getOrDefault("reset_zoom_factor", (Object)true)).booleanValue()) {
                zoomFactor = (Double)JustZoom.config.getOrDefault("base_zoom_factor", (Object)0.25);
            }
        }
        cachedFov = fov;
        return fov;
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollEvent e) {
        if (KeyBindings.keyToggleZoom.m_90857_()) {
            e.setCanceled(true);
            if (e.getScrollDelta() < 0.0) {
                if (cachedFov < 170.0) {
                    if (((Boolean)JustZoom.config.getOrDefault("zoom_out_cap", (Object)true)).booleanValue() && cachedFov >= cachedDefaultFov) {
                        return;
                    }
                    zoomFactor += ((Double)JustZoom.config.getOrDefault("zoom_out_per_scroll", (Object)0.05)).doubleValue();
                }
            } else if (e.getScrollDelta() > 0.0 && cachedFov > 1.0) {
                zoomFactor -= ((Double)JustZoom.config.getOrDefault("zoom_in_per_scroll", (Object)0.05)).doubleValue();
            }
        }
    }
}

