/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.load.registration;

import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import mezz.jei.recipes.RecipeManagerInternal;
import mezz.jei.util.ErrorUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RecipeRegistration
implements IRecipeRegistration {
    private final IJeiHelpers jeiHelpers;
    private final IIngredientManager ingredientManager;
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientVisibility ingredientVisibility;
    private final IVanillaRecipeFactory vanillaRecipeFactory;
    private final RecipeManagerInternal recipeManager;

    public RecipeRegistration(IJeiHelpers jeiHelpers, RegisteredIngredients registeredIngredients, IIngredientManager ingredientManager, IIngredientVisibility ingredientVisibility, IVanillaRecipeFactory vanillaRecipeFactory, RecipeManagerInternal recipeManager) {
        this.jeiHelpers = jeiHelpers;
        this.ingredientManager = ingredientManager;
        this.registeredIngredients = registeredIngredients;
        this.ingredientVisibility = ingredientVisibility;
        this.vanillaRecipeFactory = vanillaRecipeFactory;
        this.recipeManager = recipeManager;
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    @Override
    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return this.vanillaRecipeFactory;
    }

    @Override
    public IIngredientVisibility getIngredientVisibility() {
        return this.ingredientVisibility;
    }

    @Override
    @Deprecated
    public void addRecipes(Collection<?> recipes, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipes, "recipes");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        this.recipeManager.addRecipes(recipeCategoryUid, recipes);
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.checkNotNull(recipes, "recipes");
        this.recipeManager.addRecipes(recipeType, recipes);
    }

    @Override
    public <T> void addIngredientInfo(T ingredient, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(descriptionComponents, "descriptionComponents");
        this.addIngredientInfo(List.of(ingredient), ingredientType, descriptionComponents);
    }

    @Override
    public <T> void addIngredientInfo(List<T> ingredients, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(descriptionComponents, "descriptionComponents");
        List<IJeiIngredientInfoRecipe> recipes = IngredientInfoRecipe.create(this.registeredIngredients, ingredients, ingredientType, descriptionComponents);
        this.addRecipes(RecipeTypes.INFORMATION, recipes);
    }
}

