/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import java.util.Optional;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.KeyBindings;
import mezz.jei.input.CombinedRecipeFocusSource;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaInputHandler;
import net.minecraft.client.gui.screens.Screen;

public class BookmarkInputHandler
implements IUserInputHandler {
    private final CombinedRecipeFocusSource focusSource;
    private final BookmarkList bookmarkList;

    public BookmarkInputHandler(CombinedRecipeFocusSource focusSource, BookmarkList bookmarkList) {
        this.focusSource = focusSource;
        this.bookmarkList = bookmarkList;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (input.is(KeyBindings.bookmark)) {
            return this.handleBookmark(input);
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handleBookmark(UserInput input) {
        return this.focusSource.getIngredientUnderMouse(input).findFirst().flatMap(clicked -> {
            if (input.isSimulate() || this.bookmarkList.remove(clicked.getTypedIngredient()) || this.bookmarkList.add(clicked.getTypedIngredient())) {
                return Optional.of(LimitedAreaInputHandler.create(this, clicked.getArea()));
            }
            return Optional.empty();
        });
    }
}

