/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.color.ColorGetter;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.util.ErrorUtil;

public class RegisteredIngredientsBuilder
implements IModIngredientRegistration {
    private final List<IngredientInfo<?>> ingredientInfos = new ArrayList();
    private final Set<IIngredientType<?>> registeredIngredientSet = Collections.newSetFromMap(new IdentityHashMap());
    private final ISubtypeManager subtypeManager;

    public RegisteredIngredientsBuilder(ISubtypeManager subtypeManager) {
        this.subtypeManager = subtypeManager;
    }

    @Override
    public <V> void register(IIngredientType<V> ingredientType, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(allIngredients, "allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, "ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, "ingredientRenderer");
        Preconditions.checkArgument((ingredientRenderer.getWidth() == 16 ? 1 : 0) != 0, (Object)"the default ingredient renderer registered here will be used for drawing ingredients in the ingredient list, and it must have a width of 16");
        Preconditions.checkArgument((ingredientRenderer.getHeight() == 16 ? 1 : 0) != 0, (Object)"the default ingredient renderer registered here will be used for drawing ingredients in the ingredient list, and it must have a height of 16");
        if (this.registeredIngredientSet.contains(ingredientType)) {
            throw new IllegalArgumentException("Ingredient type has already been registered: " + ingredientType.getIngredientClass());
        }
        this.ingredientInfos.add(new IngredientInfo<V>(ingredientType, allIngredients, ingredientHelper, ingredientRenderer));
        this.registeredIngredientSet.add(ingredientType);
    }

    @Override
    public ISubtypeManager getSubtypeManager() {
        return this.subtypeManager;
    }

    @Override
    public IColorHelper getColorHelper() {
        return ColorGetter.INSTANCE;
    }

    public RegisteredIngredients build() {
        return new RegisteredIngredients(this.ingredientInfos);
    }
}

