/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.recipes.RecipeMap;
import net.minecraft.util.ResourceLocation;

public class RecipeCatalystBuilder {
    private final ImmutableListMultimap.Builder<IRecipeCategory<?>, Object> recipeCatalystsBuilder = ImmutableListMultimap.builder();
    private final ImmutableMultimap.Builder<String, ResourceLocation> categoriesForRecipeCatalystKeysBuilder = ImmutableMultimap.builder();
    private final IngredientManager ingredientManager;

    public RecipeCatalystBuilder(IngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public void addCatalysts(IRecipeCategory<?> recipeCategory, List<Object> catalystIngredients, RecipeMap recipeInputMap) {
        this.recipeCatalystsBuilder.putAll(recipeCategory, catalystIngredients);
        for (Object catalystIngredient : catalystIngredients) {
            this.addCatalyst(catalystIngredient, recipeCategory, recipeInputMap);
        }
    }

    private <T> void addCatalyst(T catalystIngredient, IRecipeCategory<?> recipeCategory, RecipeMap recipeInputMap) {
        IIngredientType<T> ingredientType = this.ingredientManager.getIngredientType(catalystIngredient);
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        recipeInputMap.addRecipeCategory(recipeCategory, catalystIngredient, ingredientHelper);
        String catalystIngredientKey = RecipeCatalystBuilder.getUniqueId(catalystIngredient, this.ingredientManager);
        this.categoriesForRecipeCatalystKeysBuilder.put((Object)catalystIngredientKey, (Object)recipeCategory.getUid());
    }

    private static <T> String getUniqueId(T ingredient, IIngredientManager ingredientManager) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
        return ingredientHelper.getUniqueId(ingredient, UidContext.Recipe);
    }

    public ImmutableListMultimap<IRecipeCategory<?>, Object> buildRecipeCatalysts() {
        return this.recipeCatalystsBuilder.build();
    }

    public ImmutableMultimap<String, ResourceLocation> buildCategoriesForRecipeCatalystKeys() {
        return this.categoriesForRecipeCatalystKeysBuilder.build();
    }
}

