/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.elements.IMouseClickedButtonCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class GuiIconButton
extends GuiButton {
    private final Consumer<List<String>> tooltipCallback;
    private final Supplier<IDrawable> iconSupplier;
    private final IMouseClickedButtonCallback mouseClickCallback;

    public GuiIconButton(int buttonId, IDrawable icon, IMouseClickedButtonCallback mouseClickCallback) {
        this(buttonId, tooltip -> {}, () -> icon, mouseClickCallback);
    }

    public GuiIconButton(int buttonId, Consumer<List<String>> tooltipCallback, Supplier<IDrawable> iconSupplier, IMouseClickedButtonCallback mouseClickCallback) {
        super(buttonId, 0, 0, 0, 0, "");
        this.tooltipCallback = tooltipCallback;
        this.iconSupplier = iconSupplier;
        this.mouseClickCallback = mouseClickCallback;
    }

    public void updateBounds(Rectangle area) {
        this.field_146128_h = area.x;
        this.field_146129_i = area.y;
        this.field_146120_f = area.width;
        this.field_146121_g = area.height;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.func_146114_a(this.field_146123_n);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
            DrawableNineSliceTexture texture = guiHelper.getButtonForState(i);
            texture.draw(mc, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
            this.func_146119_b(mc, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (!this.field_146124_l) {
                color = 0xA0A0A0;
            } else if (this.field_146123_n) {
                color = 0xFFFFA0;
            }
            float red = (float)((color |= 0xFF000000) >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)blue, (float)green, (float)alpha);
            IDrawable icon = this.iconSupplier.get();
            double xOffset = (double)this.field_146128_h + (double)(this.field_146120_f - icon.getWidth()) / 2.0;
            double yOffset = (double)this.field_146129_i + (double)(this.field_146121_g - icon.getHeight()) / 2.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)0.0);
            icon.draw(mc);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.func_146115_a()) {
            ArrayList<String> tooltip = new ArrayList<String>();
            this.tooltipCallback.accept(tooltip);
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, 150);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY) && this.mouseClickCallback.mousePressed(mc, mouseX, mouseY)) {
            this.func_146113_a(mc.func_147118_V());
            return true;
        }
        return false;
    }
}

