/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.ore;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.ore.OreColorer;
import thelm.jaopca.utils.JAOPCAConfig;

public class OreEntry
implements IOreEntry {
    protected final String oreName;
    protected List<String> oreNameSynonyms = Lists.newArrayList();
    protected String extra;
    protected String extra2;
    protected String extra3;
    protected double energy = 1.0;
    protected double rarity = 1.0;
    protected ArrayList<String> moduleBlacklist = Lists.newArrayList();
    protected EnumOreType type = EnumOreType.INGOT;
    protected boolean hasEffect = false;
    protected Color color = null;

    public OreEntry(String oreName) {
        this.oreName = oreName;
        this.extra = oreName;
        this.extra2 = oreName;
        this.extra3 = oreName;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            String s = "ingot";
            switch (this.type) {
                case DUST: {
                    s = "dust";
                    break;
                }
                case GEM: 
                case GEM_ORELESS: {
                    s = "gem";
                    break;
                }
            }
            this.hasEffect = OreColorer.getHasEffect(s, oreName);
        }
    }

    @Override
    public String getOreName() {
        return this.oreName;
    }

    @Override
    public List<String> getOreNameSynonyms() {
        return this.oreNameSynonyms;
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public String getSecondExtra() {
        return this.extra2;
    }

    @Override
    public String getThirdExtra() {
        return this.extra3;
    }

    @Override
    public double getEnergyModifier() {
        return this.energy;
    }

    @Override
    public double getRarity() {
        return this.rarity;
    }

    @Override
    public List<String> getModuleBlacklist() {
        return this.moduleBlacklist;
    }

    @Override
    public EnumOreType getOreType() {
        return this.type;
    }

    @Override
    public boolean getHasEffect() {
        return this.hasEffect;
    }

    @Override
    public int getColor() {
        if (this.color == null) {
            if (Loader.instance().hasReachedState(LoaderState.AVAILABLE) && FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                String s = "ingot";
                switch (this.type) {
                    case DUST: {
                        s = "dust";
                        break;
                    }
                    case GEM: 
                    case GEM_ORELESS: {
                        s = "gem";
                        break;
                    }
                }
                this.color = OreColorer.getColor(s, this.oreName);
                JAOPCAConfig.initColorConfigs(this);
            } else {
                return 0xFFFFFF;
            }
        }
        return this.color.getRGB() & 0xFFFFFF;
    }

    public void setOreNameSynonyms(Collection<String> synonyms) {
        this.oreNameSynonyms.clear();
        this.oreNameSynonyms.addAll(synonyms);
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setSecondExtra(String extra2) {
        this.extra2 = extra2;
    }

    public void setThirdExtra(String extra3) {
        this.extra3 = extra3;
    }

    public void setEnergyModifier(double energyModifier) {
        this.energy = energyModifier;
    }

    public void setRarity(double rarity) {
        this.rarity = rarity;
    }

    public void addBlacklistedModules(Collection<String> blacklist) {
        this.moduleBlacklist.addAll(blacklist);
    }

    public void setOreType(EnumOreType type) {
        this.type = type;
    }

    public void setHasEffect(boolean hasEffect) {
        this.hasEffect = hasEffect;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

