/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public class DamageDealer {
    private final String name;
    private float damageMultiplier;
    private Function<LivingEntity, ITextComponent> deathMessenger;
    private IDamageCallbackPre damageCallbackPre;
    private IDamageCallbackPost damageCallbackPost;
    private boolean projectile;
    private boolean explosion;
    private boolean bypassArmor;
    private boolean hurtCreative;
    private boolean absolute;
    private boolean scalable;
    private boolean fireDamage;
    private boolean magicDamage;

    public DamageDealer(String name) {
        this(name, 1.0f);
    }

    public DamageDealer(String name, float damageMultiplier) {
        this.name = name;
        this.damageMultiplier = damageMultiplier;
    }

    public void apply(Entity target, float amount) {
        this.apply(target, this.createDamage(), amount);
    }

    public void apply(Entity target, float amount, Vector3d dir) {
        this.apply(target, this.createDamage().setDirection(dir), amount);
    }

    public void apply(Entity target, Entity source, float amount) {
        this.apply(target, this.createDamage(source), amount);
    }

    public void apply(Entity target, Entity source, float amount, Vector3d dir) {
        this.apply(target, this.createDamage(source).setDirection(dir), amount);
    }

    public void apply(Entity target, Entity source, Entity cause, float amount) {
        this.apply(target, this.createDamage(source, cause), amount);
    }

    public void apply(Entity target, Entity source, Entity cause, float amount, Vector3d dir) {
        this.apply(target, this.createDamage(source, cause).setDirection(dir), amount);
    }

    protected void apply(Entity target, InfinityDamageSource dmg, float amount) {
        amount *= this.damageMultiplier;
        if (this.damageCallbackPre != null) {
            amount = this.damageCallbackPre.preDamage(target, dmg, amount);
        }
        dmg.apply(target, amount);
        if (this.damageCallbackPost != null) {
            this.damageCallbackPost.postDamage(target, dmg, amount);
        }
    }

    public String getName() {
        return this.name;
    }

    public DamageDealer setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    public DamageDealer setDamageCallback(IDamageCallbackPre damageCallback) {
        this.damageCallbackPre = damageCallback;
        return this;
    }

    public DamageDealer setDamageCallback(IDamageCallbackPost damageCallback) {
        this.damageCallbackPost = damageCallback;
        return this;
    }

    public DamageDealer setDeathMessenger(Function<LivingEntity, ITextComponent> deathMessenger) {
        this.deathMessenger = deathMessenger;
        return this;
    }

    public DamageDealer setProjectile(boolean status) {
        this.projectile = status;
        return this;
    }

    public DamageDealer setExplosion(boolean status) {
        this.explosion = status;
        return this;
    }

    public DamageDealer setBypassArmor(boolean status) {
        this.bypassArmor = status;
        return this;
    }

    public DamageDealer setHurtCreative(boolean status) {
        this.hurtCreative = status;
        return this;
    }

    public DamageDealer setAbsolute(boolean status) {
        this.absolute = status;
        return this;
    }

    public DamageDealer setScalable(boolean status) {
        this.scalable = status;
        return this;
    }

    public DamageDealer setFireDamage(boolean status) {
        this.fireDamage = status;
        return this;
    }

    public DamageDealer setMagicDamage(boolean status) {
        this.magicDamage = status;
        return this;
    }

    protected InfinityDamageSource createDamage(Entity source) {
        if (source instanceof ThrowableEntity) {
            return this.createDamage(source, ((ThrowableEntity)source).func_234616_v_());
        }
        return this.createDamage(source, source);
    }

    protected InfinityDamageSource createDamage(Entity source, Entity cause) {
        InfinityDamageSource dmg = this.createDamage();
        return dmg.setSource(source).setCause(cause);
    }

    protected InfinityDamageSource createDamage() {
        return this.applySettings(new InfinityDamageSource(this.getName()));
    }

    protected InfinityDamageSource applySettings(InfinityDamageSource dmg) {
        if (this.deathMessenger != null) {
            dmg.setDeathMessenger(this.deathMessenger);
        }
        if (this.projectile) {
            dmg.func_76349_b();
        }
        if (this.explosion) {
            dmg.func_94540_d();
        }
        if (this.bypassArmor) {
            dmg.func_76348_h();
        }
        if (this.hurtCreative) {
            dmg.func_76359_i();
        }
        if (this.absolute) {
            dmg.func_151518_m();
        }
        if (this.scalable) {
            dmg.func_76351_m();
        }
        if (this.fireDamage) {
            dmg.func_76361_j();
        }
        if (this.magicDamage) {
            dmg.func_82726_p();
        }
        return dmg;
    }

    @FunctionalInterface
    public static interface IDamageCallbackPost {
        public void postDamage(Entity var1, InfinityDamageSource var2, float var3);
    }

    @FunctionalInterface
    public static interface IDamageCallbackPre {
        public float preDamage(Entity var1, InfinityDamageSource var2, float var3);
    }

    public static class InfinityDamageSource
    extends DamageSource {
        private Entity source;
        private Entity cause;
        private Vector3d direction;
        private Function<LivingEntity, ITextComponent> deathMessenger;

        protected InfinityDamageSource(String damageTypeIn) {
            super(damageTypeIn);
        }

        public InfinityDamageSource setSource(Entity source) {
            this.source = source;
            return this;
        }

        public InfinityDamageSource setCause(Entity cause) {
            this.cause = cause;
            return this;
        }

        public InfinityDamageSource setDirection(Vector3d direction) {
            this.direction = direction;
            return this;
        }

        public InfinityDamageSource setDeathMessenger(Function<LivingEntity, ITextComponent> deathMessenger) {
            this.deathMessenger = deathMessenger;
            return this;
        }

        @Nullable
        public Entity func_76346_g() {
            return this.cause == null ? super.func_76346_g() : this.cause;
        }

        @Nullable
        public Entity func_76364_f() {
            return this.source == null ? super.func_76346_g() : this.source;
        }

        public Vector3d getDirection() {
            return this.direction;
        }

        public ITextComponent func_151519_b(LivingEntity target) {
            return this.deathMessenger == null ? super.func_151519_b(target) : this.deathMessenger.apply(target);
        }

        public void apply(Entity target, float amount) {
            if (amount > 0.0f) {
                target.func_70097_a((DamageSource)this, amount);
            }
        }
    }
}

