/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.TessellatorAbstractBase;
import com.infinityraider.infinitylib.render.tessellation.VertexData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

@OnlyIn(value=Dist.CLIENT)
public class TessellatorBakedQuad
extends TessellatorAbstractBase {
    public static final int DRAW_MODE_NOT_DRAWING = -1;
    public static final int DRAW_MODE_QUADS = 4;
    private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
    private final List<VertexData> vertexData = new ArrayList<VertexData>();
    private int drawMode = -1;
    private TextureAtlasSprite icon;
    private Function<RenderMaterial, TextureAtlasSprite> textureFunction;

    @Override
    protected void onStartDrawingQuadsCall() {
        this.startDrawing(4);
    }

    public void startDrawing(int mode) {
        if (this.drawMode != -1) {
            throw new RuntimeException("ALREADY CONSTRUCTING VERTICES");
        }
        this.drawMode = mode;
    }

    @Override
    public ImmutableList<BakedQuad> getQuads() {
        return ImmutableList.copyOf(this.quads);
    }

    @Override
    public VertexFormat getVertexFormat() {
        return DefaultVertexFormats.field_176600_a;
    }

    @Override
    protected void onDrawCall() {
        if (this.drawMode == -1) {
            throw new RuntimeException("NOT CONSTRUCTING VERTICES");
        }
        this.quads.clear();
        this.vertexData.clear();
        this.drawMode = -1;
        this.textureFunction = null;
    }

    @Override
    public TessellatorBakedQuad addQuads(List<BakedQuad> quads) {
        if (this.drawMode != -1) {
            for (BakedQuad quad : quads) {
                BakedQuad trans = this.transformQuads(quad);
                if (!this.getFace().accepts(trans.func_178210_d())) continue;
                this.quads.add(trans);
            }
        } else {
            throw new RuntimeException("NOT CONSTRUCTING VERTICES");
        }
        return this;
    }

    @Override
    public TessellatorBakedQuad addVertexWithUV(float x, float y, float z, TextureAtlasSprite sprite, float u, float v) {
        if (sprite == null) {
            sprite = this.getMissingSprite();
        }
        this.icon = sprite;
        return this.addVertexWithUV(x, y, z, sprite.func_94214_a((double)u), sprite.func_94207_b((double)v));
    }

    @Override
    public TessellatorBakedQuad addVertexWithUV(float x, float y, float z, float u, float v) {
        if (this.drawMode == -1) {
            throw new RuntimeException("NOT CONSTRUCTING VERTICES");
        }
        Vector4f pos = new Vector4f(x, y, z, 1.0f);
        this.transform(pos);
        VertexData vert = new VertexData(this.getVertexFormat());
        vert.setXYZ(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c());
        vert.setUV(u, v);
        vert.setRGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
        vert.setNormal(this.getNormal().func_195899_a(), this.getNormal().func_195900_b(), this.getNormal().func_195902_c());
        this.vertexData.add(vert);
        if (this.vertexData.size() == this.drawMode) {
            Direction dir = Direction.func_176737_a((float)this.getNormal().func_195899_a(), (float)this.getNormal().func_195900_b(), (float)this.getNormal().func_195902_c());
            if (this.getFace().accepts(dir)) {
                BakedQuadBuilder builder = new BakedQuadBuilder();
                builder.setQuadTint(this.getTintIndex());
                builder.setApplyDiffuseLighting(this.getApplyDiffuseLighting());
                builder.setQuadOrientation(dir);
                builder.setTexture(this.icon);
                for (VertexData vertex : this.vertexData) {
                    vertex.applyVertexData(builder);
                }
                this.quads.add(builder.build());
            }
            this.vertexData.clear();
        }
        return this;
    }

    @Override
    public TessellatorBakedQuad drawScaledFace(float minX, float minY, float maxX, float maxY, Direction face, TextureAtlasSprite icon, float offset) {
        if (this.getFace().accepts(face)) {
            super.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset);
        }
        return this;
    }

    @Override
    public TextureAtlasSprite getIcon(RenderMaterial source) {
        if (this.textureFunction == null || source == null) {
            return super.getIcon(source);
        }
        return this.textureFunction.apply(source);
    }

    @Override
    protected void applyColorMultiplier(Direction side) {
    }

    public TessellatorBakedQuad setTextureFunction(Function<RenderMaterial, TextureAtlasSprite> function) {
        this.textureFunction = function;
        return this;
    }
}

