/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ITessellator
extends Function<RenderMaterial, TextureAtlasSprite>,
IRenderUtilities {
    public ITessellator startDrawingQuads();

    public ImmutableList<BakedQuad> getQuads();

    public ITessellator draw();

    public VertexFormat getVertexFormat();

    public ITessellator addQuads(List<BakedQuad> var1);

    public ITessellator pushMatrix();

    public ITessellator popMatrix();

    public ITessellator addVertexWithUV(float var1, float var2, float var3, float var4, float var5);

    public ITessellator addVertexWithUV(float var1, float var2, float var3, TextureAtlasSprite var4, float var5, float var6);

    public ITessellator addScaledVertexWithUV(float var1, float var2, float var3, float var4, float var5);

    public ITessellator addScaledVertexWithUV(float var1, float var2, float var3, TextureAtlasSprite var4, float var5, float var6);

    public ITessellator drawScaledFace(float var1, float var2, float var3, float var4, Direction var5, float var6);

    public ITessellator drawScaledFace(float var1, float var2, float var3, float var4, Direction var5, float var6, float var7, float var8, float var9, float var10);

    public ITessellator drawScaledFace(float var1, float var2, float var3, float var4, Direction var5, TextureAtlasSprite var6, float var7);

    public ITessellator drawScaledFace(float var1, float var2, float var3, float var4, Direction var5, TextureAtlasSprite var6, float var7, float var8, float var9, float var10, float var11);

    public ITessellator drawScaledFaceDouble(float var1, float var2, float var3, float var4, Direction var5, float var6);

    public ITessellator drawScaledFaceDouble(float var1, float var2, float var3, float var4, Direction var5, float var6, float var7, float var8, float var9, float var10);

    public ITessellator drawScaledFaceDouble(float var1, float var2, float var3, float var4, Direction var5, TextureAtlasSprite var6, float var7);

    public ITessellator drawScaledFaceDouble(float var1, float var2, float var3, float var4, Direction var5, TextureAtlasSprite var6, float var7, float var8, float var9, float var10, float var11);

    public ITessellator drawScaledPrism(float var1, float var2, float var3, float var4, float var5, float var6);

    public ITessellator drawScaledPrism(float var1, float var2, float var3, float var4, float var5, float var6, TextureAtlasSprite var7);

    public ITessellator drawScaledCylinder(float var1, float var2, float var3, float var4, float var5, float var6, int var7);

    public ITessellator drawScaledCylinder(float var1, float var2, float var3, float var4, float var5, TextureAtlasSprite var6, float var7, int var8);

    public ITessellator drawScaledCylinderInside(float var1, float var2, float var3, float var4, float var5, float var6, int var7);

    public ITessellator drawScaledCylinderInside(float var1, float var2, float var3, float var4, float var5, TextureAtlasSprite var6, float var7, int var8);

    public ITessellator drawScaledCylinderOutside(float var1, float var2, float var3, float var4, float var5, float var6, int var7);

    public ITessellator drawScaledCylinderOutside(float var1, float var2, float var3, float var4, float var5, TextureAtlasSprite var6, float var7, int var8);

    public ITessellator translate(BlockPos var1);

    public ITessellator translate(float var1, float var2, float var3);

    public ITessellator rotate(float var1, float var2, float var3, float var4);

    public ITessellator rotate(Quaternion var1);

    public ITessellator scale(float var1, float var2, float var3);

    public ITessellator applyTransformation(Matrix4f var1);

    public ITessellator transform(Vector4f var1);

    public TextureAtlasSprite getIcon(RenderMaterial var1);

    default public ITessellator setFace(@Nullable Direction face) {
        return this.setFace(Face.fromDirection(face));
    }

    public ITessellator setFace(@Nonnull Face var1);

    public Face getFace();

    public ITessellator setNormal(float var1, float var2, float var3);

    public ITessellator setNormal(Vector3f var1);

    public Vector3f getNormal();

    public int getColor();

    public ITessellator setColorRGB(Vector3f var1);

    public ITessellator setColorRGB(float var1, float var2, float var3);

    public ITessellator setColorRGBA(float var1, float var2, float var3, float var4);

    public ITessellator setAlpha(float var1);

    public float getRed();

    public float getGreen();

    public float getBlue();

    public float getAlpha();

    public ITessellator setBrightness(int var1);

    public int getBrightness();

    public ITessellator setOverlay(int var1);

    public int getOverlay();

    public ITessellator setTintIndex(int var1);

    public int getTintIndex();

    public ITessellator setApplyDiffuseLighting(boolean var1);

    public boolean getApplyDiffuseLighting();

    @Override
    default public TextureAtlasSprite apply(RenderMaterial source) {
        return this.getIcon(source);
    }

    public static enum Face {
        NONE(false),
        GENERAL(true),
        DOWN(Direction.DOWN),
        UP(Direction.UP),
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST);

        private final Predicate<Direction> test;
        private final Vector3f normal;

        private Face(boolean general) {
            this(dir -> general, Defaults.NORMAL);
        }

        private Face(Direction direction) {
            this(dir -> dir == direction, direction.func_229386_k_());
        }

        private Face(Predicate<Direction> test, Vector3f normal) {
            this.test = test;
            this.normal = normal;
        }

        public boolean accepts(@Nullable Direction direction) {
            return this.test.test(direction);
        }

        public Vector3f getNormal() {
            return this.normal;
        }

        @Nonnull
        public static Face fromDirection(@Nullable Direction direction) {
            if (direction == null) {
                return GENERAL;
            }
            return Face.values()[direction.ordinal() + 2];
        }
    }

    public static class Defaults {
        public static final float COLOR = 1.0f;
        public static final int BRIGHTNESS = 0xF000000;
        public static final int OVERLAY = OverlayTexture.field_229196_a_;
        public static final Vector3f NORMAL = new Vector3f(0.0f, 1.0f, 0.0f);

        private Defaults() {
        }
    }
}

