/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.entity;

import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public abstract class RenderEntityAsItem<T extends Entity>
extends EntityRenderer<T>
implements IRenderUtilities {
    private final ItemStack item;
    private static final Quaternion ROTATION = Vector3f.field_229181_d_.func_229187_a_(180.0f);

    public RenderEntityAsItem(EntityRendererManager renderManager, ItemStack item) {
        super(renderManager);
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    @ParametersAreNonnullByDefault
    public void func_225623_a_(T entity, float yaw, float partialTicks, MatrixStack transforms, IRenderTypeBuffer buffer, int light) {
        transforms.func_227860_a_();
        transforms.func_227863_a_(this.getCameraOrientation());
        transforms.func_227863_a_(ROTATION);
        this.applyTransformations(entity, yaw, partialTicks, transforms);
        this.renderItem(this.item, ItemCameraTransforms.TransformType.GROUND, light, transforms, buffer);
        transforms.func_227865_b_();
    }

    protected abstract void applyTransformations(T var1, float var2, float var3, MatrixStack var4);

    @ParametersAreNonnullByDefault
    public ResourceLocation func_110775_a(T entity) {
        return this.getTextureAtlasLocation();
    }

    @Override
    public EntityRendererManager getEntityRendererManager() {
        return this.field_76990_c;
    }
}

