/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.infinityraider.infinitylib.render.tessellation.TessellatorBakedQuad;
import com.infinityraider.infinitylib.render.tessellation.TessellatorVertexBuffer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Color;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public interface IRenderUtilities {
    default public ITessellator getBakedQuadTessellator() {
        return new TessellatorBakedQuad();
    }

    default public ITessellator getVertexBufferTessellator(IRenderTypeBuffer.Impl buffer, RenderType renderType) {
        return new TessellatorVertexBuffer(buffer, renderType);
    }

    default public Random getRandom() {
        return Objects.RANDOM;
    }

    default public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType perspective, int light, MatrixStack transforms, IRenderTypeBuffer buffer) {
        this.renderItem(stack, perspective, light, OverlayTexture.field_229196_a_, transforms, buffer);
    }

    default public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType perspective, int light, int overlay, MatrixStack transforms, IRenderTypeBuffer buffer) {
        this.getItemRenderer().func_229110_a_(stack, perspective, light, overlay, transforms, buffer);
    }

    default public boolean renderBlockState(BlockState state, MatrixStack transforms, IVertexBuilder buffer) {
        return this.renderBlockState(state, Objects.DEFAULT_POS, transforms, buffer, OverlayTexture.field_229196_a_);
    }

    default public boolean renderBlockState(BlockState state, BlockPos pos, MatrixStack transforms, IVertexBuilder buffer, int overlay) {
        World world = InfinityLib.instance.getClientWorld();
        return this.renderBlockModel((IBlockDisplayReader)world, this.getModelForState(state), state, pos, transforms, buffer, false, world.func_201674_k(), state.func_209533_a(pos), overlay, (IModelData)EmptyModelData.INSTANCE);
    }

    default public boolean renderBlockModel(IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack transforms, IVertexBuilder buffer, boolean checkSides, Random random, long rand, int overlay, IModelData modelData) {
        return this.getBlockRenderer().renderModel(world, model, state, pos, transforms, buffer, checkSides, random, rand, overlay, modelData);
    }

    default public TextureAtlasSprite getMissingSprite() {
        if (Objects.missingSprite == null) {
            Objects.missingSprite = this.getSprite(MissingTextureSprite.func_195675_b());
        }
        return Objects.missingSprite;
    }

    default public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.getTextureAtlas().func_195424_a(location);
    }

    default public TextureAtlasSprite getSprite(RenderMaterial material) {
        return this.getTextureAtlas(material.func_229313_b_()).func_195424_a(material.func_229313_b_());
    }

    default public ResourceLocation getResourceLocation(String string) {
        return new ResourceLocation(string);
    }

    default public RenderMaterial getRenderMaterial(String string) {
        return this.getRenderMaterial(this.getResourceLocation(string));
    }

    default public RenderMaterial getRenderMaterial(ResourceLocation texture) {
        return new RenderMaterial(this.getTextureAtlasLocation(), texture);
    }

    default public void bindTexture(ResourceLocation location) {
        this.getTextureManager().func_110577_a(location);
    }

    default public void bindTextureAtlas() {
        this.bindTexture(this.getTextureAtlasLocation());
    }

    default public AtlasTexture getTextureAtlas() {
        return this.getTextureAtlas(this.getTextureAtlasLocation());
    }

    default public AtlasTexture getTextureAtlas(ResourceLocation location) {
        return this.getModelManager().func_229356_a_(location);
    }

    default public ResourceLocation getTextureAtlasLocation() {
        return PlayerContainer.field_226615_c_;
    }

    default public TextureManager getTextureManager() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    default public ModelManager getModelManager() {
        return Minecraft.func_71410_x().func_209506_al();
    }

    default public BlockRendererDispatcher getBlockRendererDispatcher() {
        return Minecraft.func_71410_x().func_175602_ab();
    }

    default public BlockModelRenderer getBlockRenderer() {
        return this.getBlockRendererDispatcher().func_175019_b();
    }

    default public IBakedModel getModelForState(BlockState state) {
        return this.getBlockRendererDispatcher().func_184389_a(state);
    }

    default public ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    default public ItemModelGenerator getItemModelGenerator() {
        return Objects.ITEM_MODEL_GENERATOR;
    }

    default public EntityRendererManager getEntityRendererManager() {
        return Minecraft.func_71410_x().func_175598_ae();
    }

    default public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    default public Quaternion getCameraOrientation() {
        return this.getEntityRendererManager().func_229098_b_();
    }

    default public PointOfView getPointOfView() {
        return this.getEntityRendererManager().field_78733_k.func_243230_g();
    }

    default public int getScaledWindowWidth() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    default public int getScaledWindowHeight() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p();
    }

    default public IRenderTypeBuffer.Impl getRenderTypeBuffer() {
        return Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
    }

    default public IVertexBuilder getVertexBuilder(RenderType renderType) {
        return this.getVertexBuilder((IRenderTypeBuffer)this.getRenderTypeBuffer(), renderType);
    }

    default public IVertexBuilder getVertexBuilder(IRenderTypeBuffer buffer, RenderType renderType) {
        return buffer.getBuffer(renderType);
    }

    default public Color convertColor(Vector3f color) {
        return Color.func_240743_a_((int)this.calculateColor(color));
    }

    default public int calculateColor(Vector3f color) {
        return this.calculateColor(color.func_195899_a(), color.func_195899_a(), color.func_195902_c());
    }

    default public int calculateColor(float r, float g, float b) {
        return this.calculateColor((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b));
    }

    default public int calculateColor(int r, int g, int b) {
        return 65536 * r + 256 * g + b;
    }

    default public float getPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    default public void renderCoordinateSystem(MatrixStack transforms, IRenderTypeBuffer buffer) {
        IVertexBuilder builder = this.getVertexBuilder(buffer, RenderType.func_228659_m_());
        Matrix4f matrix = transforms.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_227888_a_(matrix, 1.0f, 0.0f, 0.0f).func_225586_a_(255, 0, 0, 255).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225586_a_(0, 255, 0, 255).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 1.0f, 0.0f).func_225586_a_(0, 255, 0, 255).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 1.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
    }

    public static final class Objects {
        private static TextureAtlasSprite missingSprite;
        private static final BlockPos DEFAULT_POS;
        private static final ItemModelGenerator ITEM_MODEL_GENERATOR;
        private static final Random RANDOM;

        private Objects() {
        }

        public static boolean equals(Object a, Object b) {
            return java.util.Objects.equals(a, b);
        }

        static {
            DEFAULT_POS = new BlockPos(0, 0, 0);
            ITEM_MODEL_GENERATOR = new ItemModelGenerator();
            RANDOM = new Random();
        }
    }
}

